/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.securityprovider.ldap;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.naming.AuthenticationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Rdn;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;
import org.weakref.jmx.Managed;
import ru.cedrusdata.catalog.securityprovider.ldap.CatalogLdapSecurityProviderConfig;
import ru.cedrusdata.catalog.securityprovider.ldap.CatalogLdapSecurityProviderPlugin;
import ru.cedrusdata.catalog.securityprovider.ldap.client.CatalogLdapClient;
import ru.cedrusdata.catalog.securityprovider.ldap.client.CatalogLdapQuery;
import ru.cedrusdata.catalog.spi.classloader.CatalogThreadContextClassLoader;
import ru.cedrusdata.catalog.spi.security.CatalogPasswordAuthenticator;

public class CatalogLdapPasswordAuthenticator
implements CatalogPasswordAuthenticator {
    private static final Logger log = Logger.get(CatalogLdapPasswordAuthenticator.class);
    private final CatalogLdapClient client;
    private final String bindUser;
    private final String bindPassword;
    private final List<String> userDNPatterns;
    private final String userSearchBase;
    private final String userSearchFilter;
    private final boolean dnPatternsConfigured;
    private final Optional<Cache<String, CachedAuthenticatedUser>> cache;

    @Inject
    public CatalogLdapPasswordAuthenticator(CatalogLdapClient client, CatalogLdapSecurityProviderConfig config) {
        this.client = client;
        this.bindUser = config.getBindUser();
        this.bindPassword = config.getBindPassword();
        this.userDNPatterns = config.getAuthUserDNPatterns();
        this.userSearchBase = config.getAuthUserSearchBase();
        String userSearchFilter = config.getAuthUserSearchFilter();
        if (userSearchFilter != null) {
            userSearchFilter = userSearchFilter.replace("${USER}", "{0}");
        }
        this.userSearchFilter = userSearchFilter;
        this.dnPatternsConfigured = this.userDNPatterns != null && !this.userDNPatterns.isEmpty();
        this.cache = config.getCacheMaxSize() == 0 || config.getCacheTtl() == 0L ? Optional.empty() : Optional.of(this.createCache(config));
    }

    @SuppressModernizer
    private Cache<String, CachedAuthenticatedUser> createCache(CatalogLdapSecurityProviderConfig config) {
        return CacheBuilder.newBuilder().expireAfterWrite(config.getCacheTtl(), TimeUnit.MILLISECONDS).maximumSize((long)config.getCacheMaxSize()).recordStats().build();
    }

    public boolean authenticate(String username, Optional<String> password) {
        try (CatalogThreadContextClassLoader ignored = new CatalogThreadContextClassLoader(CatalogLdapSecurityProviderPlugin.class.getClassLoader());){
            if (!Rdn.escapeValue(username).equals(username)) {
                log.error("Username contains invalid characters: %s", new Object[]{username});
                boolean bl = false;
                return bl;
            }
            boolean bl = this.cache.isPresent() ? this.authenticate(this.cache.get(), username, password) : this.authenticateInternal(username, password);
            return bl;
        }
    }

    private boolean authenticate(Cache<String, CachedAuthenticatedUser> cache, String username, Optional<String> password) {
        CachedAuthenticatedUser cached = (CachedAuthenticatedUser)cache.getIfPresent((Object)username);
        if (cached != null) {
            log.debug(String.format("Found cached authenticated user: %s (%s)", username, cached.password.isPresent() ? "with password" : "without password"));
            if (password.isEmpty()) {
                log.debug(String.format("Authentication successful for user: %s (check exists, cache)", username));
                return true;
            }
            if (cached.password().isPresent() && password.get().equals(cached.password().get())) {
                log.debug(String.format("Authentication successful for user: %s (check password, cache)", username));
                return true;
            }
        }
        if (!this.authenticateInternal(username, password)) {
            return false;
        }
        cache.put((Object)username, (Object)new CachedAuthenticatedUser(username, password));
        return true;
    }

    private boolean authenticateInternal(String username, Optional<String> password) {
        try {
            boolean authenticated = password.isPresent() ? (this.dnPatternsConfigured ? this.authenticateDNPatterns(username, password.get()) : this.authenticateSearchAndBind(username, password.get())) : (this.dnPatternsConfigured ? this.userExistsDNPatterns(username) : this.userExistsSearch(username));
            log.debug(String.format("Authentication %s for user: %s (%s)", authenticated ? "successful" : "failed", username, password.isPresent() ? "check password" : "check exists"));
            return authenticated;
        }
        catch (NamingException e) {
            log.error((Throwable)e, "LDAP authentication failed for user: %s", new Object[]{username});
            return false;
        }
    }

    private boolean authenticateDNPatterns(String username, String password) throws NamingException {
        for (String authUserBindPattern : this.userDNPatterns) {
            String userDistinguishedName = CatalogLdapPasswordAuthenticator.userDistinguishedNameFromPattern(authUserBindPattern, username);
            if (!this.validatePassword(userDistinguishedName, password)) continue;
            return true;
        }
        return false;
    }

    private boolean userExistsDNPatterns(String username) throws NamingException {
        for (String authUserDNPattern : this.userDNPatterns) {
            String userDistinguishedName = CatalogLdapPasswordAuthenticator.userDistinguishedNameFromPattern(authUserDNPattern, username);
            if (!this.distinguishedNameExists(userDistinguishedName)) continue;
            return true;
        }
        return false;
    }

    private boolean authenticateSearchAndBind(String username, String password) throws NamingException {
        String userDistinguishedName = this.searchUserDistinguishedName(username);
        if (userDistinguishedName == null) {
            log.debug(String.format("Authentication failed for user: %s, DN not found", username));
            return false;
        }
        return this.validatePassword(userDistinguishedName, password);
    }

    private boolean userExistsSearch(String username) throws NamingException {
        return this.searchUserDistinguishedName(username) != null;
    }

    private String searchUserDistinguishedName(String username) throws NamingException {
        try {
            CatalogLdapQuery query = new CatalogLdapQuery.LdapQueryBuilder().withSearchBase(this.userSearchBase).withSearchFilter(this.userSearchFilter).withSearchFilterArguments(username).build();
            return this.client.executeLdapQuery(this.bindUser, this.bindPassword, query, results -> {
                if (results.hasMoreElements()) {
                    return ((SearchResult)results.nextElement()).getNameInNamespace();
                }
                return null;
            });
        }
        catch (NameNotFoundException e) {
            return null;
        }
    }

    private boolean distinguishedNameExists(String distinguishedName) throws NamingException {
        try {
            CatalogLdapQuery query = new CatalogLdapQuery.LdapQueryBuilder().withSearchBase(distinguishedName).withSearchFilter("(objectClass=*)").build();
            return this.client.executeLdapQuery(this.bindUser, this.bindPassword, query, Enumeration::hasMoreElements);
        }
        catch (NameNotFoundException e) {
            return false;
        }
    }

    private boolean validatePassword(String userDistinguishedName, String password) throws NamingException {
        try {
            this.client.processLdapContext(userDistinguishedName, password, context -> null);
            return true;
        }
        catch (AuthenticationException e) {
            return false;
        }
    }

    private static String userDistinguishedNameFromPattern(String pattern, String user) {
        return pattern.replace("${USER}", user);
    }

    @Managed
    public long getCacheSize() {
        return this.cache.isPresent() ? this.cache.get().size() : 0L;
    }

    @Managed
    public long getCacheHitCount() {
        return this.cache.isPresent() ? this.cache.get().stats().hitCount() : 0L;
    }

    @Managed
    public long getCacheMissCount() {
        return this.cache.isPresent() ? this.cache.get().stats().missCount() : 0L;
    }

    private record CachedAuthenticatedUser(String username, Optional<String> password) {
    }
}

