/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemCache;
import org.apache.hadoop.security.UserGroupInformation;

final class ForwardingFileSystemCache
extends FileSystem.Cache {
    private final FileSystemCache cache;

    public ForwardingFileSystemCache(FileSystemCache cache) {
        super(new Configuration(false));
        this.cache = Objects.requireNonNull(cache, "cache is null");
    }

    @Override
    FileSystem get(URI uri, Configuration conf) throws IOException {
        return this.cache.get(uri, conf);
    }

    @Override
    FileSystem getUnique(URI uri, Configuration conf) throws IOException {
        return this.cache.getUnique(uri, conf);
    }

    @Override
    void remove(FileSystem.Cache.Key ignored, FileSystem fileSystem) {
        if (fileSystem == null) {
            return;
        }
        this.cache.remove(fileSystem);
    }

    @Override
    void closeAll() throws IOException {
        this.cache.closeAll();
    }

    @Override
    void closeAll(boolean onlyAutomatic) {
        throw new UnsupportedOperationException();
    }

    @Override
    void closeAll(UserGroupInformation ugi) {
        throw new UnsupportedOperationException();
    }
}

