/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.preauth.builtin;

import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbCodec;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbErrorCode;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbException;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.common.EncryptionUtil;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.preauth.PluginRequestContext;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.preauth.builtin.EncTsPreauthMeta;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.KdcContext;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.preauth.AbstractPreauthPlugin;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.request.KdcRequest;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.EncryptedData;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.KeyUsage;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.pa.PaDataEntry;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.pa.PaEncTsEnc;

public class EncTsPreauth
extends AbstractPreauthPlugin {
    public EncTsPreauth() {
        super(new EncTsPreauthMeta());
    }

    @Override
    public boolean verify(KdcRequest kdcRequest, PluginRequestContext requestContext, PaDataEntry paData) throws KrbException {
        EncryptedData encData = KrbCodec.decode(paData.getPaDataValue(), EncryptedData.class);
        EncryptionKey clientKey = kdcRequest.getClientKey(encData.getEType());
        if (clientKey == null) {
            throw new KrbException(KrbErrorCode.KDC_ERR_ETYPE_NOSUPP);
        }
        PaEncTsEnc timestamp = EncryptionUtil.unseal(encData, clientKey, KeyUsage.AS_REQ_PA_ENC_TS, PaEncTsEnc.class);
        KdcContext kdcContext = kdcRequest.getKdcContext();
        long clockSkew = kdcContext.getConfig().getAllowableClockSkew() * 1000L;
        if (!timestamp.getAllTime().isInClockSkew(clockSkew)) {
            throw new KrbException(KrbErrorCode.KDC_ERR_PREAUTH_FAILED);
        }
        return true;
    }
}

