/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.org.apache.kerby.asn1.parse;

import io.trino.hadoop.$internal.org.apache.kerby.asn1.parse.Asn1Header;
import io.trino.hadoop.$internal.org.apache.kerby.asn1.type.Asn1Object;
import io.trino.hadoop.$internal.org.apache.kerby.asn1.util.Asn1Util;
import java.nio.ByteBuffer;

public abstract class Asn1ParseResult
extends Asn1Object {
    private Asn1Header header;
    private int bodyStart;
    private int bodyEnd;
    private ByteBuffer buffer;

    public Asn1ParseResult(Asn1Header header, int bodyStart, ByteBuffer buffer) {
        super(header.getTag());
        this.header = header;
        this.bodyStart = bodyStart;
        this.buffer = buffer;
        this.bodyEnd = this.isDefinitiveLength() ? bodyStart + header.getLength() : -1;
    }

    public Asn1Header getHeader() {
        return this.header;
    }

    public int getBodyStart() {
        return this.bodyStart;
    }

    public int getBodyEnd() {
        return this.bodyEnd;
    }

    public void setBodyEnd(int bodyEnd) {
        this.bodyEnd = bodyEnd;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public ByteBuffer getBodyBuffer() {
        ByteBuffer result = this.buffer.duplicate();
        result.position(this.bodyStart);
        int end = this.getBodyEnd();
        if (end >= this.bodyStart) {
            result.limit(end);
        }
        return result;
    }

    public byte[] readBodyBytes() {
        ByteBuffer bodyBuffer = this.getBodyBuffer();
        byte[] result = new byte[bodyBuffer.remaining()];
        bodyBuffer.get(result);
        return result;
    }

    public boolean isDefinitiveLength() {
        return this.header.isDefinitiveLength();
    }

    public int getEncodingLength() {
        return this.getHeaderLength() + this.getBodyLength();
    }

    @Override
    public int getHeaderLength() {
        int bodyLen = this.getBodyLength();
        int headerLen = Asn1Util.lengthOfTagLength(this.header.getTag().tagNo());
        return headerLen += this.header.isDefinitiveLength() ? Asn1Util.lengthOfBodyLength(bodyLen) : 1;
    }

    public int getOffset() {
        return this.getBodyStart() - this.getHeaderLength();
    }

    @Override
    public int getBodyLength() {
        if (this.isDefinitiveLength()) {
            return this.header.getLength();
        }
        if (this.getBodyEnd() != -1) {
            return this.getBodyEnd() - this.getBodyStart();
        }
        return -1;
    }

    public boolean checkBodyFinished(int pos) {
        return this.getBodyEnd() != -1 && pos >= this.getBodyEnd();
    }

    @Override
    public String simpleInfo() {
        return this.tag().typeStr() + " [" + "tag=" + this.tag() + ", off=" + this.getOffset() + ", len=" + this.getHeaderLength() + "+" + this.getBodyLength() + "]";
    }
}

