/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.org.apache.commons.configuration2;

import io.trino.hadoop.$internal.com.fasterxml.jackson.databind.JavaType;
import io.trino.hadoop.$internal.com.fasterxml.jackson.databind.ObjectMapper;
import io.trino.hadoop.$internal.com.fasterxml.jackson.databind.type.MapType;
import io.trino.hadoop.$internal.org.apache.commons.configuration2.AbstractYAMLBasedConfiguration;
import io.trino.hadoop.$internal.org.apache.commons.configuration2.FileBasedConfiguration;
import io.trino.hadoop.$internal.org.apache.commons.configuration2.HierarchicalConfiguration;
import io.trino.hadoop.$internal.org.apache.commons.configuration2.ex.ConfigurationException;
import io.trino.hadoop.$internal.org.apache.commons.configuration2.io.InputStreamSupport;
import io.trino.hadoop.$internal.org.apache.commons.configuration2.tree.ImmutableNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;

public class JSONConfiguration
extends AbstractYAMLBasedConfiguration
implements FileBasedConfiguration,
InputStreamSupport {
    private final ObjectMapper mapper = new ObjectMapper();
    private final MapType type = this.mapper.getTypeFactory().constructMapType(Map.class, String.class, Object.class);

    public JSONConfiguration() {
    }

    public JSONConfiguration(HierarchicalConfiguration<ImmutableNode> c) {
        super(c);
    }

    @Override
    public void read(Reader in) throws ConfigurationException {
        try {
            this.load((Map)this.mapper.readValue(in, (JavaType)this.type));
        }
        catch (Exception e) {
            JSONConfiguration.rethrowException(e);
        }
    }

    @Override
    public void write(Writer out) throws ConfigurationException, IOException {
        this.mapper.writer().writeValue(out, this.constructMap(this.getNodeModel().getNodeHandler().getRootNode()));
    }

    @Override
    public void read(InputStream in) throws ConfigurationException {
        try {
            this.load((Map)this.mapper.readValue(in, (JavaType)this.type));
        }
        catch (Exception e) {
            JSONConfiguration.rethrowException(e);
        }
    }
}

