/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.com.microsoft.azure.storage.file;

import io.trino.hadoop.$internal.com.microsoft.azure.storage.core.Utility;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.file.FileRange;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class FileRangeHandler
extends DefaultHandler {
    private final Stack<String> elementStack = new Stack();
    private StringBuilder bld = new StringBuilder();
    private final ArrayList<FileRange> fileRanges = new ArrayList();
    private long startOffset;
    private long endOffset;

    FileRangeHandler() {
    }

    protected static ArrayList<FileRange> getFileRanges(InputStream streamRef) throws ParserConfigurationException, SAXException, IOException {
        SAXParser saxParser = Utility.getSAXParser();
        FileRangeHandler handler = new FileRangeHandler();
        saxParser.parse(streamRef, (DefaultHandler)handler);
        return handler.fileRanges;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.elementStack.push(localName);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String currentNode = this.elementStack.pop();
        if (!localName.equals(currentNode)) {
            throw new SAXException("The response received is invalid or improperly formatted.");
        }
        String value = this.bld.toString();
        if (value.isEmpty()) {
            value = null;
        }
        if ("Range".equals(currentNode)) {
            FileRange fileRangeRef = new FileRange(this.startOffset, this.endOffset);
            this.fileRanges.add(fileRangeRef);
        } else if ("Start".equals(currentNode)) {
            this.startOffset = Long.parseLong(value);
        } else if ("End".equals(currentNode)) {
            this.endOffset = Long.parseLong(value);
        }
        this.bld = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.bld.append(ch, start, length);
    }
}

