/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.util.JsonUtil;
import org.apache.iceberg.view.ViewMetadata;
import org.apache.iceberg.view.ViewMetadataParser;
import ru.cedrusdata.catalog.iceberg.LoadObjectResponse;

public class LoadObjectResponseParser {
    private static final String IDENTIFIER = "identifier";
    private static final String TABLE_METADATA = "table-metadata";
    private static final String TABLE_METADATA_LOCATION = "table-metadata-location";
    private static final String VIEW_METADATA = "view-metadata";
    private static final String VIEW_METADATA_LOCATION = "view-metadata-location";

    private LoadObjectResponseParser() {
    }

    public static void toJson(LoadObjectResponse response, JsonGenerator gen) throws IOException {
        Objects.requireNonNull(response, "Invalid load object response: null");
        gen.writeStartObject();
        gen.writeStringField(IDENTIFIER, response.identifier().toString());
        if (response.tableMetadata().isPresent()) {
            gen.writeFieldName(TABLE_METADATA);
            TableMetadataParser.toJson((TableMetadata)response.tableMetadata().get(), (JsonGenerator)gen);
        }
        if (response.tableMetadataLocation().isPresent()) {
            gen.writeStringField(TABLE_METADATA_LOCATION, response.tableMetadataLocation().get());
        }
        if (response.viewMetadata().isPresent()) {
            gen.writeFieldName(VIEW_METADATA);
            ViewMetadataParser.toJson((ViewMetadata)response.viewMetadata().get(), (JsonGenerator)gen);
        }
        if (response.viewMetadataLocation().isPresent()) {
            gen.writeStringField(VIEW_METADATA_LOCATION, response.viewMetadataLocation().get());
        }
        gen.writeEndObject();
    }

    public static LoadObjectResponse fromJson(JsonNode json) {
        Objects.requireNonNull(json, "Cannot parse load object response from null object");
        TableIdentifier identifier = TableIdentifier.parse((String)JsonUtil.getString((String)IDENTIFIER, (JsonNode)json));
        Optional<TableMetadata> tableMetadata = json.has(TABLE_METADATA) ? Optional.of(TableMetadataParser.fromJson((JsonNode)JsonUtil.get((String)TABLE_METADATA, (JsonNode)json))) : Optional.empty();
        Optional<String> tableMetadataLocation = json.has(TABLE_METADATA_LOCATION) ? Optional.of(JsonUtil.getString((String)TABLE_METADATA_LOCATION, (JsonNode)json)) : Optional.empty();
        Optional<ViewMetadata> viewMetadata = json.has(VIEW_METADATA) ? Optional.of(ViewMetadataParser.fromJson((JsonNode)JsonUtil.get((String)VIEW_METADATA, (JsonNode)json))) : Optional.empty();
        Optional<String> viewMetadataLocation = json.has(VIEW_METADATA_LOCATION) ? Optional.of(JsonUtil.getString((String)VIEW_METADATA_LOCATION, (JsonNode)json)) : Optional.empty();
        return new LoadObjectResponse(identifier, tableMetadata, tableMetadataLocation, viewMetadata, viewMetadataLocation);
    }
}

