/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.filesystem.s3;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.CedrusDataBootstrap;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.plugin.base.jmx.MBeanServerModule;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.weakref.jmx.guice.MBeanModule;
import ru.cedrusdata.catalog.filesystem.s3.CatalogS3FileSystemConfig;
import ru.cedrusdata.catalog.filesystem.s3.CatalogS3FileSystemJmxObjectNameGeneratorModule;
import ru.cedrusdata.catalog.filesystem.s3.CatalogS3FileSystemModule;
import ru.cedrusdata.catalog.filesystem.s3.CatalogS3TrinoFileSystemFactory;
import ru.cedrusdata.catalog.spi.CatalogPluginContext;
import ru.cedrusdata.catalog.spi.classloader.CatalogThreadContextClassLoader;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystemFactory;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystemProvider;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystemType;
import ru.cedrusdata.catalog.spi.jmx.CatalogJmxNameCheck;

public class CatalogS3FileSystemProvider
implements CatalogFileSystemProvider {
    public CatalogFileSystemType getFileSystemType() {
        return CatalogFileSystemType.S3;
    }

    public CatalogFileSystemFactory createFileSystemFactory(CatalogPluginContext context, String fileSystemName, Map<String, String> config) {
        Optional<String> error = CatalogS3FileSystemConfig.validateProperties(config = config != null ? new HashMap<String, String>(config) : new HashMap());
        if (error.isPresent()) {
            throw (RuntimeException)context.configExceptionProvider().apply("Invalid properties: " + error.get());
        }
        ClassLoader classLoader = CatalogS3FileSystemProvider.class.getClassLoader();
        try (CatalogThreadContextClassLoader ignored = new CatalogThreadContextClassLoader(classLoader);){
            CedrusDataBootstrap app = new CedrusDataBootstrap(new Module[]{new MBeanModule(), new MBeanServerModule(), new CatalogS3FileSystemJmxObjectNameGeneratorModule(fileSystemName), binder -> {
                binder.bind(CatalogJmxNameCheck.class).toInstance((Object)context.jmxNameCheck());
                binder.bind(OpenTelemetry.class).toInstance((Object)context.fileSystemOpenTelemetry());
            }, new CatalogS3FileSystemModule()});
            Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).quiet().initialize();
            CatalogFileSystemFactory catalogFileSystemFactory = (CatalogFileSystemFactory)injector.getInstance(CatalogS3TrinoFileSystemFactory.class);
            return catalogFileSystemFactory;
        }
    }

    public Set<String> redactedPropertyKeys() {
        return Set.of("secret-key");
    }
}

