/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.iceberg.Schema;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.AssignFreshIds;
import org.apache.iceberg.types.AssignIds;
import org.apache.iceberg.types.CheckCompatibility;
import org.apache.iceberg.types.FindTypeVisitor;
import org.apache.iceberg.types.GetProjectedIds;
import org.apache.iceberg.types.IndexById;
import org.apache.iceberg.types.IndexByName;
import org.apache.iceberg.types.IndexParents;
import org.apache.iceberg.types.PruneColumns;
import org.apache.iceberg.types.ReassignDoc;
import org.apache.iceberg.types.ReassignIds;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class TypeUtil {
    private static final int HEADER_SIZE = 12;
    private static final int[] MAX_PRECISION = new int[24];
    private static final int[] REQUIRED_LENGTH = new int[40];

    private TypeUtil() {
    }

    public static Schema project(Schema schema, Set<Integer> fieldIds) {
        Preconditions.checkNotNull((Object)schema, (Object)"Schema cannot be null");
        Types.StructType result = TypeUtil.project(schema.asStruct(), fieldIds);
        if (schema.asStruct().equals(result)) {
            return schema;
        }
        if (result != null) {
            if (schema.getAliases() != null) {
                return new Schema(result.fields(), schema.getAliases());
            }
            return new Schema(result.fields());
        }
        return new Schema(Collections.emptyList(), schema.getAliases());
    }

    public static Types.StructType project(Types.StructType struct, Set<Integer> fieldIds) {
        Preconditions.checkNotNull((Object)struct, (Object)"Struct cannot be null");
        Preconditions.checkNotNull(fieldIds, (Object)"Field ids cannot be null");
        Type result = TypeUtil.visit((Type)struct, new PruneColumns(fieldIds, false));
        if (struct.equals(result)) {
            return struct;
        }
        if (result != null) {
            return result.asStructType();
        }
        return Types.StructType.of(new Types.NestedField[0]);
    }

    public static Schema select(Schema schema, Set<Integer> fieldIds) {
        Preconditions.checkNotNull((Object)schema, (Object)"Schema cannot be null");
        Types.StructType result = TypeUtil.select(schema.asStruct(), fieldIds);
        if (Objects.equals(schema.asStruct(), result)) {
            return schema;
        }
        if (result != null) {
            if (schema.getAliases() != null) {
                return new Schema(result.fields(), schema.getAliases());
            }
            return new Schema(result.fields());
        }
        return new Schema((List<Types.NestedField>)ImmutableList.of(), schema.getAliases());
    }

    public static Types.StructType select(Types.StructType struct, Set<Integer> fieldIds) {
        Preconditions.checkNotNull((Object)struct, (Object)"Struct cannot be null");
        Preconditions.checkNotNull(fieldIds, (Object)"Field ids cannot be null");
        Type result = TypeUtil.visit((Type)struct, new PruneColumns(fieldIds, true));
        if (struct.equals(result)) {
            return struct;
        }
        if (result != null) {
            return result.asStructType();
        }
        return Types.StructType.of(new Types.NestedField[0]);
    }

    public static Set<Integer> getProjectedIds(Schema schema) {
        return ImmutableSet.copyOf(TypeUtil.getIdsInternal(schema.asStruct(), true));
    }

    public static Set<Integer> getProjectedIds(Type type) {
        if (type.isPrimitiveType()) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf(TypeUtil.getIdsInternal(type, true));
    }

    private static Set<Integer> getIdsInternal(Type type, boolean includeStructIds) {
        return TypeUtil.visit(type, new GetProjectedIds(includeStructIds));
    }

    public static Types.StructType selectNot(Types.StructType struct, Set<Integer> fieldIds) {
        Set<Integer> projectedIds = TypeUtil.getIdsInternal(struct, false);
        projectedIds.removeAll(fieldIds);
        return TypeUtil.project(struct, projectedIds);
    }

    public static Schema selectNot(Schema schema, Set<Integer> fieldIds) {
        Set<Integer> projectedIds = TypeUtil.getIdsInternal(schema.asStruct(), false);
        projectedIds.removeAll(fieldIds);
        return TypeUtil.project(schema, projectedIds);
    }

    public static Schema join(Schema left, Schema right) {
        ArrayList joinedColumns = Lists.newArrayList(left.columns());
        for (Types.NestedField rightColumn : right.columns()) {
            Types.NestedField leftColumn = left.findField(rightColumn.fieldId());
            if (leftColumn == null) {
                joinedColumns.add(rightColumn);
                continue;
            }
            Preconditions.checkArgument((boolean)leftColumn.equals(rightColumn), (String)"Schemas have different columns with same id: %s, %s", (Object)leftColumn, (Object)rightColumn);
        }
        return new Schema(joinedColumns);
    }

    public static Map<String, Integer> indexByName(Types.StructType struct) {
        IndexByName indexer = new IndexByName();
        TypeUtil.visit((Type)struct, indexer);
        return indexer.byName();
    }

    public static Map<Integer, String> indexNameById(Types.StructType struct) {
        IndexByName indexer = new IndexByName();
        TypeUtil.visit((Type)struct, indexer);
        return indexer.byId();
    }

    public static Map<Integer, String> indexQuotedNameById(Types.StructType struct, Function<String, String> quotingFunc) {
        IndexByName indexer = new IndexByName(quotingFunc);
        TypeUtil.visit((Type)struct, indexer);
        return indexer.byId();
    }

    public static Map<String, Integer> indexByLowerCaseName(Types.StructType struct) {
        HashMap indexByLowerCaseName = Maps.newHashMap();
        TypeUtil.indexByName(struct).forEach((name, integer) -> indexByLowerCaseName.put(name.toLowerCase(Locale.ROOT), integer));
        return indexByLowerCaseName;
    }

    public static Map<Integer, Types.NestedField> indexById(Types.StructType struct) {
        return TypeUtil.visit((Type)struct, new IndexById());
    }

    public static Map<Integer, Integer> indexParents(Types.StructType struct) {
        return ImmutableMap.copyOf(TypeUtil.visit((Type)struct, new IndexParents()));
    }

    public static Type assignFreshIds(Type type, NextID nextId) {
        return TypeUtil.visit(type, new AssignFreshIds(nextId));
    }

    public static Schema assignFreshIds(Schema schema, NextID nextId) {
        Types.StructType struct = TypeUtil.visit((Type)schema.asStruct(), new AssignFreshIds(nextId)).asStructType();
        return new Schema(struct.fields(), TypeUtil.refreshIdentifierFields(struct, schema));
    }

    public static Schema assignFreshIds(int schemaId, Schema schema, NextID nextId) {
        Types.StructType struct = TypeUtil.visit((Type)schema.asStruct(), new AssignFreshIds(nextId)).asStructType();
        return new Schema(schemaId, struct.fields(), TypeUtil.refreshIdentifierFields(struct, schema));
    }

    public static Schema assignFreshIds(Schema schema, Schema baseSchema, NextID nextId) {
        Types.StructType struct = TypeUtil.visit((Type)schema.asStruct(), new AssignFreshIds(schema, baseSchema, nextId)).asStructType();
        return new Schema(struct.fields(), TypeUtil.refreshIdentifierFields(struct, schema));
    }

    public static Set<Integer> refreshIdentifierFields(Types.StructType freshSchema, Schema baseSchema) {
        Map<String, Integer> nameToId = TypeUtil.indexByName(freshSchema);
        Set<String> identifierFieldNames = baseSchema.identifierFieldNames();
        identifierFieldNames.forEach(name -> Preconditions.checkArgument((boolean)nameToId.containsKey(name), (String)"Cannot find ID for identifier field %s in schema %s", (Object)name, (Object)freshSchema));
        return identifierFieldNames.stream().map(nameToId::get).collect(Collectors.toSet());
    }

    public static Schema assignIncreasingFreshIds(Schema schema) {
        AtomicInteger lastColumnId = new AtomicInteger(0);
        return TypeUtil.assignFreshIds(schema, lastColumnId::incrementAndGet);
    }

    public static Schema reassignIds(Schema schema, Schema idSourceSchema) {
        return TypeUtil.reassignIds(schema, idSourceSchema, true);
    }

    public static Schema reassignDoc(Schema schema, Schema docSourceSchema) {
        ReassignDoc visitor = new ReassignDoc(docSourceSchema);
        return new Schema(((Type)((CustomOrderSchemaVisitor)visitor).schema(schema, new VisitFuture(schema.asStruct(), visitor))).asStructType().fields());
    }

    public static Schema reassignIds(Schema schema, Schema idSourceSchema, boolean caseSensitive) {
        Types.StructType struct = TypeUtil.visit(schema, new ReassignIds(idSourceSchema, null, caseSensitive)).asStructType();
        return new Schema(struct.fields(), TypeUtil.refreshIdentifierFields(struct, schema));
    }

    public static Schema reassignOrRefreshIds(Schema schema, Schema idSourceSchema) {
        return TypeUtil.reassignOrRefreshIds(schema, idSourceSchema, true);
    }

    public static Schema reassignOrRefreshIds(Schema schema, Schema idSourceSchema, boolean caseSensitive) {
        AtomicInteger highest = new AtomicInteger(idSourceSchema.highestFieldId());
        Types.StructType struct = TypeUtil.visit(schema, new ReassignIds(idSourceSchema, highest::incrementAndGet, caseSensitive)).asStructType();
        return new Schema(struct.fields(), TypeUtil.refreshIdentifierFields(struct, schema));
    }

    public static Type assignIds(Type type, GetID getId) {
        return TypeUtil.visit(type, new AssignIds(getId));
    }

    public static Type find(Schema schema, Predicate<Type> predicate) {
        return TypeUtil.visit(schema, new FindTypeVisitor(predicate));
    }

    public static boolean isPromotionAllowed(Type from, Type.PrimitiveType to) {
        if (from.equals(to)) {
            return true;
        }
        switch (from.typeId()) {
            case INTEGER: {
                return to.typeId() == Type.TypeID.LONG;
            }
            case FLOAT: {
                return to.typeId() == Type.TypeID.DOUBLE;
            }
            case DECIMAL: {
                Types.DecimalType fromDecimal = (Types.DecimalType)from;
                if (to.typeId() != Type.TypeID.DECIMAL) {
                    return false;
                }
                Types.DecimalType toDecimal = (Types.DecimalType)to;
                return fromDecimal.scale() == toDecimal.scale() && fromDecimal.precision() <= toDecimal.precision();
            }
        }
        return false;
    }

    public static void validateWriteSchema(Schema tableSchema, Schema writeSchema, Boolean checkNullability, Boolean checkOrdering) {
        String errMsg = "Cannot write incompatible dataset to table with schema:";
        TypeUtil.checkSchemaCompatibility(errMsg, tableSchema, writeSchema, checkNullability, checkOrdering);
    }

    public static void validateSchema(String context, Schema expectedSchema, Schema providedSchema, boolean checkNullability, boolean checkOrdering) {
        String errMsg = String.format("Provided %s schema is incompatible with expected schema:", context);
        TypeUtil.checkSchemaCompatibility(errMsg, expectedSchema, providedSchema, checkNullability, checkOrdering);
    }

    private static void checkSchemaCompatibility(String errMsg, Schema schema, Schema providedSchema, boolean checkNullability, boolean checkOrdering) {
        List<String> errors = checkNullability ? CheckCompatibility.writeCompatibilityErrors(schema, providedSchema, checkOrdering) : CheckCompatibility.typeCompatibilityErrors(schema, providedSchema, checkOrdering);
        if (!errors.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append(errMsg).append("\n").append(schema).append("\n").append("Provided schema:").append("\n").append(providedSchema).append("\n").append("Problems:");
            for (String error : errors) {
                sb.append("\n* ").append(error);
            }
            throw new IllegalArgumentException(sb.toString());
        }
    }

    public static int estimateSize(Types.NestedField field) {
        return TypeUtil.estimateSize(field.type());
    }

    private static int estimateSize(Type type) {
        switch (type.typeId()) {
            case BOOLEAN: {
                return 1;
            }
            case INTEGER: 
            case FLOAT: 
            case DATE: {
                return 4;
            }
            case LONG: 
            case DOUBLE: 
            case TIME: 
            case TIMESTAMP: {
                return 8;
            }
            case STRING: {
                return 54;
            }
            case UUID: {
                return 28;
            }
            case FIXED: {
                return ((Types.FixedType)type).length();
            }
            case BINARY: {
                return 80;
            }
            case DECIMAL: {
                return 44;
            }
            case STRUCT: {
                Types.StructType struct = (Types.StructType)type;
                return 12 + struct.fields().stream().mapToInt(TypeUtil::estimateSize).sum();
            }
            case LIST: {
                Types.ListType list = (Types.ListType)type;
                return 12 + 5 * TypeUtil.estimateSize(list.elementType());
            }
            case MAP: {
                Types.MapType map = (Types.MapType)type;
                int entrySize = 12 + TypeUtil.estimateSize(map.keyType()) + TypeUtil.estimateSize(map.valueType());
                return 12 + 5 * entrySize;
            }
        }
        return 16;
    }

    public static <T> T visit(Schema schema, SchemaVisitor<T> visitor) {
        return visitor.schema(schema, TypeUtil.visit((Type)schema.asStruct(), visitor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T visit(Type type, SchemaVisitor<T> visitor) {
        switch (type.typeId()) {
            case STRUCT: {
                Types.StructType struct = type.asNestedType().asStructType();
                ArrayList results = Lists.newArrayListWithExpectedSize((int)struct.fields().size());
                for (Types.NestedField field : struct.fields()) {
                    T result;
                    visitor.beforeField(field);
                    try {
                        result = TypeUtil.visit(field.type(), visitor);
                    }
                    finally {
                        visitor.afterField(field);
                    }
                    results.add(visitor.field(field, result));
                }
                return visitor.struct(struct, results);
            }
            case LIST: {
                T elementResult;
                Types.ListType list = type.asNestedType().asListType();
                Types.NestedField elementField = list.field(list.elementId());
                visitor.beforeListElement(elementField);
                try {
                    elementResult = TypeUtil.visit(list.elementType(), visitor);
                }
                finally {
                    visitor.afterListElement(elementField);
                }
                return visitor.list(list, elementResult);
            }
            case MAP: {
                T valueResult;
                T keyResult;
                Types.MapType map = type.asNestedType().asMapType();
                Types.NestedField keyField = map.field(map.keyId());
                visitor.beforeMapKey(keyField);
                try {
                    keyResult = TypeUtil.visit(map.keyType(), visitor);
                }
                finally {
                    visitor.afterMapKey(keyField);
                }
                Types.NestedField valueField = map.field(map.valueId());
                visitor.beforeMapValue(valueField);
                try {
                    valueResult = TypeUtil.visit(map.valueType(), visitor);
                }
                finally {
                    visitor.afterMapValue(valueField);
                }
                return visitor.map(map, keyResult, valueResult);
            }
        }
        return visitor.primitive(type.asPrimitiveType());
    }

    public static <T> T visit(Schema schema, CustomOrderSchemaVisitor<T> visitor) {
        return visitor.schema(schema, new VisitFuture(schema.asStruct(), visitor));
    }

    public static <T> T visit(Type type, CustomOrderSchemaVisitor<T> visitor) {
        switch (type.typeId()) {
            case STRUCT: {
                Types.StructType struct = type.asNestedType().asStructType();
                ArrayList results = Lists.newArrayListWithExpectedSize((int)struct.fields().size());
                for (Types.NestedField field : struct.fields()) {
                    results.add(new VisitFieldFuture(field, visitor));
                }
                return visitor.struct(struct, Iterables.transform((Iterable)results, VisitFieldFuture::get));
            }
            case LIST: {
                Types.ListType list = type.asNestedType().asListType();
                return visitor.list(list, new VisitFuture(list.elementType(), visitor));
            }
            case MAP: {
                Types.MapType map = type.asNestedType().asMapType();
                return visitor.map(map, new VisitFuture(map.keyType(), visitor), new VisitFuture(map.valueType(), visitor));
            }
        }
        return visitor.primitive(type.asPrimitiveType());
    }

    static int decimalMaxPrecision(int numBytes) {
        Preconditions.checkArgument((numBytes >= 0 && numBytes < 24 ? 1 : 0) != 0, (String)"Unsupported decimal length: %s", (int)numBytes);
        return MAX_PRECISION[numBytes];
    }

    public static int decimalRequiredBytes(int precision) {
        Preconditions.checkArgument((precision >= 0 && precision < 40 ? 1 : 0) != 0, (String)"Unsupported decimal precision: %s", (int)precision);
        return REQUIRED_LENGTH[precision];
    }

    static {
        for (int len = 0; len < MAX_PRECISION.length; ++len) {
            TypeUtil.MAX_PRECISION[len] = (int)Math.floor(Math.log10(Math.pow(2.0, 8 * len - 1) - 1.0));
        }
        for (int precision = 0; precision < REQUIRED_LENGTH.length; ++precision) {
            TypeUtil.REQUIRED_LENGTH[precision] = -1;
            for (int len = 0; len < MAX_PRECISION.length; ++len) {
                if (precision > MAX_PRECISION[len]) continue;
                TypeUtil.REQUIRED_LENGTH[precision] = len;
                break;
            }
            if (REQUIRED_LENGTH[precision] >= 0) continue;
            throw new IllegalStateException("Could not find required length for precision " + precision);
        }
    }

    private static class VisitFieldFuture<T>
    implements Supplier<T> {
        private final Types.NestedField field;
        private final CustomOrderSchemaVisitor<T> visitor;

        private VisitFieldFuture(Types.NestedField field, CustomOrderSchemaVisitor<T> visitor) {
            this.field = field;
            this.visitor = visitor;
        }

        @Override
        public T get() {
            return this.visitor.field(this.field, new VisitFuture(this.field.type(), this.visitor));
        }
    }

    private static class VisitFuture<T>
    implements Supplier<T> {
        private final Type type;
        private final CustomOrderSchemaVisitor<T> visitor;

        private VisitFuture(Type type, CustomOrderSchemaVisitor<T> visitor) {
            this.type = type;
            this.visitor = visitor;
        }

        @Override
        public T get() {
            return TypeUtil.visit(this.type, this.visitor);
        }
    }

    public static class CustomOrderSchemaVisitor<T> {
        public T schema(Schema schema, Supplier<T> structResult) {
            return null;
        }

        public T struct(Types.StructType struct, Iterable<T> fieldResults) {
            return null;
        }

        public T field(Types.NestedField field, Supplier<T> fieldResult) {
            return null;
        }

        public T list(Types.ListType list, Supplier<T> elementResult) {
            return null;
        }

        public T map(Types.MapType map, Supplier<T> keyResult, Supplier<T> valueResult) {
            return null;
        }

        public T primitive(Type.PrimitiveType primitive) {
            return null;
        }
    }

    public static class SchemaVisitor<T> {
        public void beforeField(Types.NestedField field) {
        }

        public void afterField(Types.NestedField field) {
        }

        public void beforeListElement(Types.NestedField elementField) {
            this.beforeField(elementField);
        }

        public void afterListElement(Types.NestedField elementField) {
            this.afterField(elementField);
        }

        public void beforeMapKey(Types.NestedField keyField) {
            this.beforeField(keyField);
        }

        public void afterMapKey(Types.NestedField keyField) {
            this.afterField(keyField);
        }

        public void beforeMapValue(Types.NestedField valueField) {
            this.beforeField(valueField);
        }

        public void afterMapValue(Types.NestedField valueField) {
            this.afterField(valueField);
        }

        public T schema(Schema schema, T structResult) {
            return null;
        }

        public T struct(Types.StructType struct, List<T> fieldResults) {
            return null;
        }

        public T field(Types.NestedField field, T fieldResult) {
            return null;
        }

        public T list(Types.ListType list, T elementResult) {
            return null;
        }

        public T map(Types.MapType map, T keyResult, T valueResult) {
            return null;
        }

        public T primitive(Type.PrimitiveType primitive) {
            return null;
        }
    }

    public static interface GetID {
        public int get(int var1);
    }

    public static interface NextID {
        public int get();
    }
}

