/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hdfs.authentication;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.ConfigBinder;
import io.trino.hdfs.HdfsConfigurationInitializer;
import io.trino.hdfs.authentication.CachingKerberosHadoopAuthentication;
import io.trino.hdfs.authentication.DirectHdfsAuthentication;
import io.trino.hdfs.authentication.ForHdfs;
import io.trino.hdfs.authentication.HadoopAuthentication;
import io.trino.hdfs.authentication.HdfsAuthentication;
import io.trino.hdfs.authentication.HdfsKerberosConfig;
import io.trino.hdfs.authentication.ImpersonatingHdfsAuthentication;
import io.trino.hdfs.authentication.KerberosHadoopAuthentication;
import io.trino.hdfs.authentication.NoHdfsAuthentication;
import io.trino.hdfs.authentication.SimpleHadoopAuthentication;
import io.trino.plugin.base.authentication.KerberosAuthentication;
import io.trino.plugin.base.authentication.KerberosConfiguration;
import io.trino.plugin.base.security.UserNameProvider;

public final class AuthenticationModules {
    private AuthenticationModules() {
    }

    public static Module noHdfsAuthenticationModule() {
        return binder -> binder.bind(HdfsAuthentication.class).to(NoHdfsAuthentication.class).in(Scopes.SINGLETON);
    }

    public static Module simpleImpersonatingHdfsAuthenticationModule() {
        return binder -> {
            binder.bind(HadoopAuthentication.class).annotatedWith(ForHdfs.class).to(SimpleHadoopAuthentication.class);
            OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(UserNameProvider.class, ForHdfs.class)).setDefault().toInstance((Object)UserNameProvider.SIMPLE_USER_NAME_PROVIDER);
            binder.bind(HdfsAuthentication.class).to(ImpersonatingHdfsAuthentication.class).in(Scopes.SINGLETON);
        };
    }

    public static Module kerberosHdfsAuthenticationModule() {
        return new Module(){

            public void configure(Binder binder) {
                binder.bind(HdfsAuthentication.class).to(DirectHdfsAuthentication.class).in(Scopes.SINGLETON);
                ConfigBinder.configBinder((Binder)binder).bindConfig(HdfsKerberosConfig.class);
            }

            @Inject
            @Provides
            @Singleton
            @ForHdfs
            HadoopAuthentication createHadoopAuthentication(HdfsKerberosConfig config, HdfsConfigurationInitializer updater) {
                String principal = config.getHdfsTrinoPrincipal();
                KerberosConfiguration.Builder builder = new KerberosConfiguration.Builder().withKerberosPrincipal(principal);
                config.getHdfsTrinoKeytab().ifPresent(arg_0 -> ((KerberosConfiguration.Builder)builder).withKeytabLocation(arg_0));
                config.getHdfsTrinoCredentialCacheLocation().ifPresent(arg_0 -> ((KerberosConfiguration.Builder)builder).withCredentialCacheLocation(arg_0));
                return AuthenticationModules.createCachingKerberosHadoopAuthentication(builder.build(), updater);
            }
        };
    }

    public static Module kerberosImpersonatingHdfsAuthenticationModule() {
        return new Module(){

            public void configure(Binder binder) {
                OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(UserNameProvider.class, ForHdfs.class)).setDefault().toInstance((Object)UserNameProvider.SIMPLE_USER_NAME_PROVIDER);
                binder.bind(HdfsAuthentication.class).to(ImpersonatingHdfsAuthentication.class).in(Scopes.SINGLETON);
                ConfigBinder.configBinder((Binder)binder).bindConfig(HdfsKerberosConfig.class);
            }

            @Inject
            @Provides
            @Singleton
            @ForHdfs
            HadoopAuthentication createHadoopAuthentication(HdfsKerberosConfig config, HdfsConfigurationInitializer updater) {
                String principal = config.getHdfsTrinoPrincipal();
                KerberosConfiguration.Builder builder = new KerberosConfiguration.Builder().withKerberosPrincipal(principal);
                config.getHdfsTrinoKeytab().ifPresent(arg_0 -> ((KerberosConfiguration.Builder)builder).withKeytabLocation(arg_0));
                config.getHdfsTrinoCredentialCacheLocation().ifPresent(arg_0 -> ((KerberosConfiguration.Builder)builder).withCredentialCacheLocation(arg_0));
                return AuthenticationModules.createCachingKerberosHadoopAuthentication(builder.build(), updater);
            }
        };
    }

    public static HadoopAuthentication createCachingKerberosHadoopAuthentication(KerberosConfiguration kerberosConfiguration, HdfsConfigurationInitializer updater) {
        KerberosAuthentication kerberosAuthentication = new KerberosAuthentication(kerberosConfiguration);
        KerberosHadoopAuthentication kerberosHadoopAuthentication = KerberosHadoopAuthentication.createKerberosHadoopAuthentication(kerberosAuthentication, updater);
        return new CachingKerberosHadoopAuthentication(kerberosHadoopAuthentication);
    }
}

