/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.openmetrics;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MetricsConfig {
    private static final Splitter NAME_SPLITTER = Splitter.on((char)'|').trimResults().omitEmptyStrings();
    private List<ObjectName> jmxObjectNames = ImmutableList.of();

    public List<ObjectName> getJmxObjectNames() {
        return this.jmxObjectNames;
    }

    @Config(value="openmetrics.jmx-object-names")
    @ConfigDescription(value="JMX object names to include when retrieving all metrics, separated by '|'")
    public MetricsConfig setJmxObjectNames(String names) {
        this.jmxObjectNames = (List)NAME_SPLITTER.splitToStream((CharSequence)names).map(MetricsConfig::toObjectName).collect(ImmutableList.toImmutableList());
        return this;
    }

    public MetricsConfig setJmxObjectNames(List<ObjectName> names) {
        this.jmxObjectNames = ImmutableList.copyOf(names);
        return this;
    }

    private static ObjectName toObjectName(String name) {
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

