/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.tracing;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoInput;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoInputStream;
import io.trino.filesystem.tracing.FileSystemAttributes;
import io.trino.filesystem.tracing.Tracing;
import io.trino.filesystem.tracing.TracingInput;
import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;

final class TracingInputFile
implements TrinoInputFile {
    private final Tracer tracer;
    private final TrinoInputFile delegate;
    private Optional<Long> length;
    private boolean isLastModifiedKnown;

    public TracingInputFile(Tracer tracer, TrinoInputFile delegate, Optional<Long> length, Optional<Instant> lastModified) {
        this.tracer = Objects.requireNonNull(tracer, "tracer is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.length = Objects.requireNonNull(length, "length is null");
        this.isLastModifiedKnown = lastModified.isPresent();
    }

    @Override
    public TrinoInput newInput() throws IOException {
        Span span = this.tracer.spanBuilder("InputFile.newInput").setAttribute(FileSystemAttributes.FILE_LOCATION, (Object)this.toString()).setAllAttributes(Tracing.attribute(FileSystemAttributes.FILE_SIZE, this.length)).startSpan();
        return Tracing.withTracing(span, () -> new TracingInput(this.tracer, this.delegate.newInput(), this.location(), this.length));
    }

    @Override
    public TrinoInputStream newStream() throws IOException {
        Span span = this.tracer.spanBuilder("InputFile.newStream").setAttribute(FileSystemAttributes.FILE_LOCATION, (Object)this.toString()).setAllAttributes(Tracing.attribute(FileSystemAttributes.FILE_SIZE, this.length)).startSpan();
        return Tracing.withTracing(span, this.delegate::newStream);
    }

    @Override
    public long length() throws IOException {
        if (this.length.isPresent()) {
            return this.delegate.length();
        }
        Span span = this.tracer.spanBuilder("InputFile.length").setAttribute(FileSystemAttributes.FILE_LOCATION, (Object)this.toString()).startSpan();
        long fileLength = Tracing.withTracing(span, this.delegate::length);
        this.length = Optional.of(fileLength);
        return fileLength;
    }

    @Override
    public Instant lastModified() throws IOException {
        if (this.isLastModifiedKnown) {
            return this.delegate.lastModified();
        }
        Span span = this.tracer.spanBuilder("InputFile.lastModified").setAttribute(FileSystemAttributes.FILE_LOCATION, (Object)this.toString()).startSpan();
        Instant fileLastModified = Tracing.withTracing(span, this.delegate::lastModified);
        this.isLastModifiedKnown = true;
        return fileLastModified;
    }

    @Override
    public boolean exists() throws IOException {
        Span span = this.tracer.spanBuilder("InputFile.exists").setAttribute(FileSystemAttributes.FILE_LOCATION, (Object)this.toString()).startSpan();
        return Tracing.withTracing(span, this.delegate::exists);
    }

    @Override
    public Location location() {
        return this.delegate.location();
    }

    public String toString() {
        return this.location().toString();
    }
}

