/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.memory;

import io.airlift.slice.Slice;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoInput;
import java.io.EOFException;
import java.io.IOException;
import java.util.Objects;

class MemoryInput
implements TrinoInput {
    private final Location location;
    private final Slice data;
    private boolean closed;

    public MemoryInput(Location location, Slice data) {
        this.location = Objects.requireNonNull(location, "location is null");
        this.data = Objects.requireNonNull(data, "data is null");
    }

    @Override
    public void readFully(long position, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        this.ensureOpen();
        Objects.checkFromIndexSize(bufferOffset, bufferLength, buffer.length);
        if (position < 0L) {
            throw new IOException("Negative seek offset");
        }
        if (position + (long)bufferLength > (long)this.data.length()) {
            throw new EOFException("Cannot read %s bytes at %s. File size is %s: %s".formatted(position, bufferLength, this.data.length(), this.location));
        }
        this.data.getBytes(Math.toIntExact(position), buffer, bufferOffset, bufferLength);
    }

    @Override
    public int readTail(byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        this.ensureOpen();
        Objects.checkFromIndexSize(bufferOffset, bufferLength, buffer.length);
        int readSize = Math.min(this.data.length(), bufferLength);
        this.readFully(this.data.length() - readSize, buffer, bufferOffset, readSize);
        return readSize;
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Output stream closed: " + String.valueOf(this.location));
        }
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public String toString() {
        return this.location.toString();
    }
}

