/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.configuration;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.tomlj.Toml;
import org.tomlj.TomlArray;
import org.tomlj.TomlTable;

public class TomlConfiguration {
    private final TomlTable tomlTable;

    public static TomlConfiguration createTomlConfiguration(File file) {
        Preconditions.checkArgument((boolean)file.getName().endsWith(".toml"), (Object)"TOML files must end with '.toml'");
        try {
            return new TomlConfiguration((TomlTable)Toml.parse((Path)file.toPath()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public TomlConfiguration(TomlTable tomlTable) {
        this.tomlTable = Objects.requireNonNull(tomlTable, "tomlTable is null");
    }

    public Map<String, String> getParentConfiguration() {
        return (Map)this.tomlTable.entryPathSet().stream().filter(entry -> ((List)entry.getKey()).size() == 1).collect(ImmutableMap.toImmutableMap(entry -> (String)Iterators.getOnlyElement(((List)entry.getKey()).iterator()), entry -> TomlConfiguration.tomlValueToString(entry.getValue())));
    }

    public Set<String> getNamespaces() {
        return (Set)this.tomlTable.entrySet().stream().filter(entry -> entry.getValue() instanceof TomlTable).map(Map.Entry::getKey).collect(ImmutableSet.toImmutableSet());
    }

    public Map<String, String> getNamespaceConfiguration(String namespace) {
        Preconditions.checkArgument((boolean)this.tomlTable.contains(namespace), (String)"Namespace %s not found", (Object)namespace);
        return (Map)this.tomlTable.getTable(namespace).dottedEntrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> TomlConfiguration.tomlValueToString(entry.getValue())));
    }

    private static String tomlValueToString(Object object) {
        if (object instanceof TomlArray) {
            TomlArray tomlArray = (TomlArray)object;
            return tomlArray.toList().stream().map(TomlConfiguration::tomlValueToString).collect(Collectors.joining(","));
        }
        return object.toString();
    }
}

