/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx.guice;

import com.google.inject.Key;
import com.google.inject.util.Types;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.BiFunction;
import javax.management.ObjectName;
import org.weakref.jmx.ObjectNameGenerator;

class MapMapping<K, V> {
    private final BiFunction<ObjectNameGenerator, Map.Entry<K, V>, ObjectName> objectNameFunction;
    private final Class<K> keyClass;
    private final Class<V> valueClass;

    MapMapping(Class<K> keyClass, Class<V> valueClass, BiFunction<ObjectNameGenerator, Map.Entry<K, V>, ObjectName> objectNameFunction) {
        this.keyClass = keyClass;
        this.valueClass = valueClass;
        this.objectNameFunction = objectNameFunction;
    }

    public BiFunction<ObjectNameGenerator, Map.Entry<K, V>, ObjectName> getObjectNameFunction() {
        return this.objectNameFunction;
    }

    public Key<Map<K, V>> getKey() {
        return Key.get((Type)Types.mapOf(this.keyClass, this.valueClass));
    }
}

