/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Map;
import java.util.Objects;

@JsonTypeName(value="SecurityProviderCreateRequest")
public class SecurityProviderCreateRequest {
    private final String securityProviderName;
    private final String type;
    private final String description;
    private final Map<String, String> properties;

    @JsonCreator
    public SecurityProviderCreateRequest(@JsonProperty(value="security-provider-name") String securityProviderName, @JsonProperty(value="type") String type, @JsonProperty(value="description") String description, @JsonProperty(value="properties") Map<String, String> properties) {
        this.securityProviderName = securityProviderName;
        this.type = type;
        this.description = description;
        this.properties = properties;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="security-provider-name")
    public String getSecurityProviderName() {
        return this.securityProviderName;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="properties")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityProviderCreateRequest securityProviderCreateRequest = (SecurityProviderCreateRequest)o;
        return Objects.equals(this.securityProviderName, securityProviderCreateRequest.securityProviderName) && Objects.equals(this.type, securityProviderCreateRequest.type) && Objects.equals(this.description, securityProviderCreateRequest.description) && Objects.equals(this.properties, securityProviderCreateRequest.properties);
    }

    public int hashCode() {
        return Objects.hash(this.securityProviderName, this.type, this.description, this.properties);
    }

    public String toString() {
        return "SecurityProviderCreateRequest{securityProviderName='" + this.securityProviderName + "', type='" + this.type + "', description='" + this.description + "', properties='" + String.valueOf(this.properties) + "'}";
    }

    public static class Builder {
        private String securityProviderName;
        private String type;
        private String description;
        private Map<String, String> properties;

        private Builder() {
        }

        public Builder setSecurityProviderName(String securityProviderName) {
            this.securityProviderName = securityProviderName;
            return this;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setProperties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public SecurityProviderCreateRequest build() {
            return new SecurityProviderCreateRequest(this.securityProviderName, this.type, this.description, this.properties);
        }
    }
}

