/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import java.util.Set;

@JsonTypeName(value="RevokeRoleRequest")
public class RevokeRoleRequest {
    private final String principalName;
    private final Set<String> roles;

    @JsonCreator
    public RevokeRoleRequest(@JsonProperty(value="principal-name") String principalName, @JsonProperty(value="roles") Set<String> roles) {
        this.principalName = principalName;
        this.roles = roles;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="principal-name")
    public String getPrincipalName() {
        return this.principalName;
    }

    @JsonProperty(value="roles")
    public Set<String> getRoles() {
        return this.roles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RevokeRoleRequest revokeRoleRequest = (RevokeRoleRequest)o;
        return Objects.equals(this.principalName, revokeRoleRequest.principalName) && Objects.equals(this.roles, revokeRoleRequest.roles);
    }

    public int hashCode() {
        return Objects.hash(this.principalName, this.roles);
    }

    public String toString() {
        return "RevokeRoleRequest{principalName='" + this.principalName + "', roles='" + String.valueOf(this.roles) + "'}";
    }

    public static class Builder {
        private String principalName;
        private Set<String> roles;

        private Builder() {
        }

        public Builder setPrincipalName(String principalName) {
            this.principalName = principalName;
            return this;
        }

        public Builder setRoles(Set<String> roles) {
            this.roles = roles;
            return this;
        }

        public RevokeRoleRequest build() {
            return new RevokeRoleRequest(this.principalName, this.roles);
        }
    }
}

