/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;

@JsonTypeName(value="PrivilegedActionInfo")
public class PrivilegedActionInfo {
    private final String action;
    private final String securableType;

    @JsonCreator
    public PrivilegedActionInfo(@JsonProperty(value="action") String action, @JsonProperty(value="securable-type") String securableType) {
        this.action = action;
        this.securableType = securableType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="action")
    public String getAction() {
        return this.action;
    }

    @JsonProperty(value="securable-type")
    public String getSecurableType() {
        return this.securableType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrivilegedActionInfo privilegedActionInfo = (PrivilegedActionInfo)o;
        return Objects.equals(this.action, privilegedActionInfo.action) && Objects.equals(this.securableType, privilegedActionInfo.securableType);
    }

    public int hashCode() {
        return Objects.hash(this.action, this.securableType);
    }

    public String toString() {
        return "PrivilegedActionInfo{action='" + this.action + "', securableType='" + this.securableType + "'}";
    }

    public static class Builder {
        private String action;
        private String securableType;

        private Builder() {
        }

        public Builder setAction(String action) {
            this.action = action;
            return this;
        }

        public Builder setSecurableType(String securableType) {
            this.securableType = securableType;
            return this;
        }

        public PrivilegedActionInfo build() {
            return new PrivilegedActionInfo(this.action, this.securableType);
        }
    }
}

