/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import ru.cedrusdata.catalog.spi.model.BooleanValue;
import ru.cedrusdata.catalog.spi.model.StringValue;

@JsonTypeName(value="PrincipalUpdateRequest")
public class PrincipalUpdateRequest {
    private final StringValue principalName;
    private final StringValue password;
    private final BooleanValue active;
    private final StringValue identifiedWith;
    private final Map<String, String> updatedProperties;
    private final Set<String> removedProperties;

    @JsonCreator
    public PrincipalUpdateRequest(@JsonProperty(value="principal-name") StringValue principalName, @JsonProperty(value="password") StringValue password, @JsonProperty(value="active") BooleanValue active, @JsonProperty(value="identified-with") StringValue identifiedWith, @JsonProperty(value="updated-properties") Map<String, String> updatedProperties, @JsonProperty(value="removed-properties") Set<String> removedProperties) {
        this.principalName = principalName;
        this.password = password;
        this.active = active;
        this.identifiedWith = identifiedWith;
        this.updatedProperties = updatedProperties;
        this.removedProperties = removedProperties;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="principal-name")
    public StringValue getPrincipalName() {
        return this.principalName;
    }

    @JsonProperty(value="password")
    public StringValue getPassword() {
        return this.password;
    }

    @JsonProperty(value="active")
    public BooleanValue getActive() {
        return this.active;
    }

    @JsonProperty(value="identified-with")
    public StringValue getIdentifiedWith() {
        return this.identifiedWith;
    }

    @JsonProperty(value="updated-properties")
    public Map<String, String> getUpdatedProperties() {
        return this.updatedProperties;
    }

    @JsonProperty(value="removed-properties")
    public Set<String> getRemovedProperties() {
        return this.removedProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrincipalUpdateRequest principalUpdateRequest = (PrincipalUpdateRequest)o;
        return Objects.equals(this.principalName, principalUpdateRequest.principalName) && Objects.equals(this.password, principalUpdateRequest.password) && Objects.equals(this.active, principalUpdateRequest.active) && Objects.equals(this.identifiedWith, principalUpdateRequest.identifiedWith) && Objects.equals(this.updatedProperties, principalUpdateRequest.updatedProperties) && Objects.equals(this.removedProperties, principalUpdateRequest.removedProperties);
    }

    public int hashCode() {
        return Objects.hash(this.principalName, this.password, this.active, this.identifiedWith, this.updatedProperties, this.removedProperties);
    }

    public String toString() {
        return "PrincipalUpdateRequest{principalName='" + String.valueOf(this.principalName) + "', password='" + String.valueOf(this.password) + "', active='" + String.valueOf(this.active) + "', identifiedWith='" + String.valueOf(this.identifiedWith) + "', updatedProperties='" + String.valueOf(this.updatedProperties) + "', removedProperties='" + String.valueOf(this.removedProperties) + "'}";
    }

    public static class Builder {
        private StringValue principalName;
        private StringValue password;
        private BooleanValue active;
        private StringValue identifiedWith;
        private Map<String, String> updatedProperties;
        private Set<String> removedProperties;

        private Builder() {
        }

        public Builder setPrincipalName(StringValue principalName) {
            this.principalName = principalName;
            return this;
        }

        public Builder setPassword(StringValue password) {
            this.password = password;
            return this;
        }

        public Builder setActive(BooleanValue active) {
            this.active = active;
            return this;
        }

        public Builder setIdentifiedWith(StringValue identifiedWith) {
            this.identifiedWith = identifiedWith;
            return this;
        }

        public Builder setUpdatedProperties(Map<String, String> updatedProperties) {
            this.updatedProperties = updatedProperties;
            return this;
        }

        public Builder setRemovedProperties(Set<String> removedProperties) {
            this.removedProperties = removedProperties;
            return this;
        }

        public PrincipalUpdateRequest build() {
            return new PrincipalUpdateRequest(this.principalName, this.password, this.active, this.identifiedWith, this.updatedProperties, this.removedProperties);
        }
    }
}

