/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import ru.cedrusdata.catalog.spi.model.MaintenanceOperationConfig;

@JsonTypeName(value="MaintenanceOperationStartRequest")
public class MaintenanceOperationStartRequest {
    private final MaintenanceOperationConfig operationConfig;
    private final String targetObjectGroupName;
    private final String targetCatalogName;
    private final String targetNamespaceName;
    private final String targetObjectName;

    @JsonCreator
    public MaintenanceOperationStartRequest(@JsonProperty(value="operation-config") MaintenanceOperationConfig operationConfig, @JsonProperty(value="target-object-group-name") String targetObjectGroupName, @JsonProperty(value="target-catalog-name") String targetCatalogName, @JsonProperty(value="target-namespace-name") String targetNamespaceName, @JsonProperty(value="target-object-name") String targetObjectName) {
        this.operationConfig = operationConfig;
        this.targetObjectGroupName = targetObjectGroupName;
        this.targetCatalogName = targetCatalogName;
        this.targetNamespaceName = targetNamespaceName;
        this.targetObjectName = targetObjectName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="operation-config")
    public MaintenanceOperationConfig getOperationConfig() {
        return this.operationConfig;
    }

    @JsonProperty(value="target-object-group-name")
    public String getTargetObjectGroupName() {
        return this.targetObjectGroupName;
    }

    @JsonProperty(value="target-catalog-name")
    public String getTargetCatalogName() {
        return this.targetCatalogName;
    }

    @JsonProperty(value="target-namespace-name")
    public String getTargetNamespaceName() {
        return this.targetNamespaceName;
    }

    @JsonProperty(value="target-object-name")
    public String getTargetObjectName() {
        return this.targetObjectName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaintenanceOperationStartRequest maintenanceOperationStartRequest = (MaintenanceOperationStartRequest)o;
        return Objects.equals(this.operationConfig, maintenanceOperationStartRequest.operationConfig) && Objects.equals(this.targetObjectGroupName, maintenanceOperationStartRequest.targetObjectGroupName) && Objects.equals(this.targetCatalogName, maintenanceOperationStartRequest.targetCatalogName) && Objects.equals(this.targetNamespaceName, maintenanceOperationStartRequest.targetNamespaceName) && Objects.equals(this.targetObjectName, maintenanceOperationStartRequest.targetObjectName);
    }

    public int hashCode() {
        return Objects.hash(this.operationConfig, this.targetObjectGroupName, this.targetCatalogName, this.targetNamespaceName, this.targetObjectName);
    }

    public String toString() {
        return "MaintenanceOperationStartRequest{operationConfig='" + String.valueOf(this.operationConfig) + "', targetObjectGroupName='" + this.targetObjectGroupName + "', targetCatalogName='" + this.targetCatalogName + "', targetNamespaceName='" + this.targetNamespaceName + "', targetObjectName='" + this.targetObjectName + "'}";
    }

    public static class Builder {
        private MaintenanceOperationConfig operationConfig;
        private String targetObjectGroupName;
        private String targetCatalogName;
        private String targetNamespaceName;
        private String targetObjectName;

        private Builder() {
        }

        public Builder setOperationConfig(MaintenanceOperationConfig operationConfig) {
            this.operationConfig = operationConfig;
            return this;
        }

        public Builder setTargetObjectGroupName(String targetObjectGroupName) {
            this.targetObjectGroupName = targetObjectGroupName;
            return this;
        }

        public Builder setTargetCatalogName(String targetCatalogName) {
            this.targetCatalogName = targetCatalogName;
            return this;
        }

        public Builder setTargetNamespaceName(String targetNamespaceName) {
            this.targetNamespaceName = targetNamespaceName;
            return this;
        }

        public Builder setTargetObjectName(String targetObjectName) {
            this.targetObjectName = targetObjectName;
            return this;
        }

        public MaintenanceOperationStartRequest build() {
            return new MaintenanceOperationStartRequest(this.operationConfig, this.targetObjectGroupName, this.targetCatalogName, this.targetNamespaceName, this.targetObjectName);
        }
    }
}

