/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import ru.cedrusdata.catalog.spi.model.JobScheduleConfig;
import ru.cedrusdata.catalog.spi.model.MaintenanceOperationConfig;

@JsonTypeName(value="MaintenanceJobCreateRequest")
public class MaintenanceJobCreateRequest {
    private final String jobName;
    private final MaintenanceOperationConfig operationConfig;
    private final JobScheduleConfig scheduleConfig;
    private final String targetObjectGroupName;
    private final String runAs;
    private final String description;

    @JsonCreator
    public MaintenanceJobCreateRequest(@JsonProperty(value="job-name") String jobName, @JsonProperty(value="operation-config") MaintenanceOperationConfig operationConfig, @JsonProperty(value="schedule-config") JobScheduleConfig scheduleConfig, @JsonProperty(value="target-object-group-name") String targetObjectGroupName, @JsonProperty(value="run-as") String runAs, @JsonProperty(value="description") String description) {
        this.jobName = jobName;
        this.operationConfig = operationConfig;
        this.scheduleConfig = scheduleConfig;
        this.targetObjectGroupName = targetObjectGroupName;
        this.runAs = runAs;
        this.description = description;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="job-name")
    public String getJobName() {
        return this.jobName;
    }

    @JsonProperty(value="operation-config")
    public MaintenanceOperationConfig getOperationConfig() {
        return this.operationConfig;
    }

    @JsonProperty(value="schedule-config")
    public JobScheduleConfig getScheduleConfig() {
        return this.scheduleConfig;
    }

    @JsonProperty(value="target-object-group-name")
    public String getTargetObjectGroupName() {
        return this.targetObjectGroupName;
    }

    @JsonProperty(value="run-as")
    public String getRunAs() {
        return this.runAs;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaintenanceJobCreateRequest maintenanceJobCreateRequest = (MaintenanceJobCreateRequest)o;
        return Objects.equals(this.jobName, maintenanceJobCreateRequest.jobName) && Objects.equals(this.operationConfig, maintenanceJobCreateRequest.operationConfig) && Objects.equals(this.scheduleConfig, maintenanceJobCreateRequest.scheduleConfig) && Objects.equals(this.targetObjectGroupName, maintenanceJobCreateRequest.targetObjectGroupName) && Objects.equals(this.runAs, maintenanceJobCreateRequest.runAs) && Objects.equals(this.description, maintenanceJobCreateRequest.description);
    }

    public int hashCode() {
        return Objects.hash(this.jobName, this.operationConfig, this.scheduleConfig, this.targetObjectGroupName, this.runAs, this.description);
    }

    public String toString() {
        return "MaintenanceJobCreateRequest{jobName='" + this.jobName + "', operationConfig='" + String.valueOf(this.operationConfig) + "', scheduleConfig='" + String.valueOf(this.scheduleConfig) + "', targetObjectGroupName='" + this.targetObjectGroupName + "', runAs='" + this.runAs + "', description='" + this.description + "'}";
    }

    public static class Builder {
        private String jobName;
        private MaintenanceOperationConfig operationConfig;
        private JobScheduleConfig scheduleConfig;
        private String targetObjectGroupName;
        private String runAs;
        private String description;

        private Builder() {
        }

        public Builder setJobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public Builder setOperationConfig(MaintenanceOperationConfig operationConfig) {
            this.operationConfig = operationConfig;
            return this;
        }

        public Builder setScheduleConfig(JobScheduleConfig scheduleConfig) {
            this.scheduleConfig = scheduleConfig;
            return this;
        }

        public Builder setTargetObjectGroupName(String targetObjectGroupName) {
            this.targetObjectGroupName = targetObjectGroupName;
            return this;
        }

        public Builder setRunAs(String runAs) {
            this.runAs = runAs;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public MaintenanceJobCreateRequest build() {
            return new MaintenanceJobCreateRequest(this.jobName, this.operationConfig, this.scheduleConfig, this.targetObjectGroupName, this.runAs, this.description);
        }
    }
}

