/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;

@JsonTypeName(value="LocaleInfo")
public class LocaleInfo {
    private final String language;
    private final String displayName;

    @JsonCreator
    public LocaleInfo(@JsonProperty(value="language") String language, @JsonProperty(value="display-name") String displayName) {
        this.language = language;
        this.displayName = displayName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="language")
    public String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="display-name")
    public String getDisplayName() {
        return this.displayName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocaleInfo localeInfo = (LocaleInfo)o;
        return Objects.equals(this.language, localeInfo.language) && Objects.equals(this.displayName, localeInfo.displayName);
    }

    public int hashCode() {
        return Objects.hash(this.language, this.displayName);
    }

    public String toString() {
        return "LocaleInfo{language='" + this.language + "', displayName='" + this.displayName + "'}";
    }

    public static class Builder {
        private String language;
        private String displayName;

        private Builder() {
        }

        public Builder setLanguage(String language) {
            this.language = language;
            return this;
        }

        public Builder setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public LocaleInfo build() {
            return new LocaleInfo(this.language, this.displayName);
        }
    }
}

