/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import ru.cedrusdata.catalog.spi.model.StringValue;

@JsonTypeName(value="IcebergCatalogUpdateRequest")
public class IcebergCatalogUpdateRequest {
    private final StringValue catalogName;
    private final StringValue description;
    private final StringValue fileSystemLocation;
    private final Map<String, String> updatedProperties;
    private final Set<String> removedProperties;

    @JsonCreator
    public IcebergCatalogUpdateRequest(@JsonProperty(value="catalog-name") StringValue catalogName, @JsonProperty(value="description") StringValue description, @JsonProperty(value="file-system-location") StringValue fileSystemLocation, @JsonProperty(value="updated-properties") Map<String, String> updatedProperties, @JsonProperty(value="removed-properties") Set<String> removedProperties) {
        this.catalogName = catalogName;
        this.description = description;
        this.fileSystemLocation = fileSystemLocation;
        this.updatedProperties = updatedProperties;
        this.removedProperties = removedProperties;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="catalog-name")
    public StringValue getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty(value="description")
    public StringValue getDescription() {
        return this.description;
    }

    @JsonProperty(value="file-system-location")
    public StringValue getFileSystemLocation() {
        return this.fileSystemLocation;
    }

    @JsonProperty(value="updated-properties")
    public Map<String, String> getUpdatedProperties() {
        return this.updatedProperties;
    }

    @JsonProperty(value="removed-properties")
    public Set<String> getRemovedProperties() {
        return this.removedProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IcebergCatalogUpdateRequest icebergCatalogUpdateRequest = (IcebergCatalogUpdateRequest)o;
        return Objects.equals(this.catalogName, icebergCatalogUpdateRequest.catalogName) && Objects.equals(this.description, icebergCatalogUpdateRequest.description) && Objects.equals(this.fileSystemLocation, icebergCatalogUpdateRequest.fileSystemLocation) && Objects.equals(this.updatedProperties, icebergCatalogUpdateRequest.updatedProperties) && Objects.equals(this.removedProperties, icebergCatalogUpdateRequest.removedProperties);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.description, this.fileSystemLocation, this.updatedProperties, this.removedProperties);
    }

    public String toString() {
        return "IcebergCatalogUpdateRequest{catalogName='" + String.valueOf(this.catalogName) + "', description='" + String.valueOf(this.description) + "', fileSystemLocation='" + String.valueOf(this.fileSystemLocation) + "', updatedProperties='" + String.valueOf(this.updatedProperties) + "', removedProperties='" + String.valueOf(this.removedProperties) + "'}";
    }

    public static class Builder {
        private StringValue catalogName;
        private StringValue description;
        private StringValue fileSystemLocation;
        private Map<String, String> updatedProperties;
        private Set<String> removedProperties;

        private Builder() {
        }

        public Builder setCatalogName(StringValue catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public Builder setDescription(StringValue description) {
            this.description = description;
            return this;
        }

        public Builder setFileSystemLocation(StringValue fileSystemLocation) {
            this.fileSystemLocation = fileSystemLocation;
            return this;
        }

        public Builder setUpdatedProperties(Map<String, String> updatedProperties) {
            this.updatedProperties = updatedProperties;
            return this;
        }

        public Builder setRemovedProperties(Set<String> removedProperties) {
            this.removedProperties = removedProperties;
            return this;
        }

        public IcebergCatalogUpdateRequest build() {
            return new IcebergCatalogUpdateRequest(this.catalogName, this.description, this.fileSystemLocation, this.updatedProperties, this.removedProperties);
        }
    }
}

