/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Objects;

@JsonTypeName(value="AccessCheck")
public class AccessCheck {
    private final Boolean allowed;
    private final String descriptor;
    private final List<AccessCheck> childChecks;

    @JsonCreator
    public AccessCheck(@JsonProperty(value="allowed") Boolean allowed, @JsonProperty(value="descriptor") String descriptor, @JsonProperty(value="child-checks") List<AccessCheck> childChecks) {
        this.allowed = allowed;
        this.descriptor = descriptor;
        this.childChecks = childChecks;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="allowed")
    public Boolean getAllowed() {
        return this.allowed;
    }

    @JsonProperty(value="descriptor")
    public String getDescriptor() {
        return this.descriptor;
    }

    @JsonProperty(value="child-checks")
    public List<AccessCheck> getChildChecks() {
        return this.childChecks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessCheck accessCheck = (AccessCheck)o;
        return Objects.equals(this.allowed, accessCheck.allowed) && Objects.equals(this.descriptor, accessCheck.descriptor) && Objects.equals(this.childChecks, accessCheck.childChecks);
    }

    public int hashCode() {
        return Objects.hash(this.allowed, this.descriptor, this.childChecks);
    }

    public String toString() {
        return "AccessCheck{allowed='" + this.allowed + "', descriptor='" + this.descriptor + "', childChecks='" + String.valueOf(this.childChecks) + "'}";
    }

    public static class Builder {
        private Boolean allowed;
        private String descriptor;
        private List<AccessCheck> childChecks;

        private Builder() {
        }

        public Builder setAllowed(Boolean allowed) {
            this.allowed = allowed;
            return this;
        }

        public Builder setDescriptor(String descriptor) {
            this.descriptor = descriptor;
            return this;
        }

        public Builder setChildChecks(List<AccessCheck> childChecks) {
            this.childChecks = childChecks;
            return this;
        }

        public AccessCheck build() {
            return new AccessCheck(this.allowed, this.descriptor, this.childChecks);
        }
    }
}

