/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.computeengine.result;

import java.util.HashMap;
import java.util.Map;
import ru.cedrusdata.catalog.spi.computeengine.result.Accumulator;
import ru.cedrusdata.catalog.spi.computeengine.result.ComputeEngineResultAggregator;
import ru.cedrusdata.catalog.spi.exception.CatalogInternalServerErrorException;

public class CompositeComputeEngineResultAggregator
implements ComputeEngineResultAggregator {
    private final Map<String, Accumulator> accumulators;

    private CompositeComputeEngineResultAggregator(Map<String, Accumulator> accumulators) {
        this.accumulators = accumulators;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public void addResult(Map<String, String> result) {
        for (Map.Entry<String, String> entry : result.entrySet()) {
            Accumulator accumulator = this.accumulators.get(entry.getKey());
            if (accumulator == null) {
                throw new CatalogInternalServerErrorException(String.format("No accumulator for result key \"%s\"", entry.getKey()));
            }
            try {
                accumulator.add(entry.getValue());
            }
            catch (Exception e) {
                throw new CatalogInternalServerErrorException(String.format("Accumulator for result key \"%s\" failed: %s", entry.getKey(), e.getMessage()), (Throwable)e);
            }
        }
    }

    @Override
    public Map<String, String> reduce() {
        HashMap<String, String> result = HashMap.newHashMap(this.accumulators.size());
        for (Map.Entry<String, Accumulator> entry : this.accumulators.entrySet()) {
            try {
                result.put(entry.getKey(), entry.getValue().reduce());
            }
            catch (Exception e) {
                throw new CatalogInternalServerErrorException(String.format("Failed to reduce results for key \"%s\": %s", entry.getKey(), e.getMessage()));
            }
        }
        return result;
    }

    public static class Builder {
        private final Map<String, Accumulator> accumulators = new HashMap<String, Accumulator>();

        public Builder add(String key, Accumulator accumulator) {
            Accumulator oldAccumulator = this.accumulators.putIfAbsent(key, accumulator);
            if (oldAccumulator != null) {
                throw new IllegalStateException("Accumulator already defined for key: " + key);
            }
            return this;
        }

        public CompositeComputeEngineResultAggregator build() {
            if (this.accumulators.isEmpty()) {
                throw new IllegalStateException("No accumulators provided");
            }
            return new CompositeComputeEngineResultAggregator(Map.copyOf(this.accumulators));
        }
    }
}

