/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jaxrs.tracing;

import com.google.inject.Inject;
import io.airlift.jaxrs.tracing.TracingFilter;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.FeatureContext;
import java.util.Objects;

public class TracingDynamicFeature
implements DynamicFeature {
    private final OpenTelemetry openTelemetry;
    private final Tracer tracer;

    @Inject
    public TracingDynamicFeature(OpenTelemetry openTelemetry, Tracer tracer) {
        this.openTelemetry = Objects.requireNonNull(openTelemetry, "openTelemetry is null");
        this.tracer = Objects.requireNonNull(tracer, "tracer is null");
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        context.register((Object)new TracingFilter(this.openTelemetry, this.tracer, resourceInfo.getResourceClass().getName(), resourceInfo.getResourceMethod().getName()));
    }
}

