/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.RecordComponent;
import java.util.Set;
import java.util.stream.Stream;

public class RecordAutoDetectModule
extends SimpleModule {
    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
        context.insertAnnotationIntrospector((AnnotationIntrospector)new Introspector());
    }

    private static class Introspector
    extends AnnotationIntrospector {
        private static final VisibilityChecker.Std RECORD_VISIBILITY_CHECKER = VisibilityChecker.Std.defaultInstance().withGetterVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withCreatorVisibility(JsonAutoDetect.Visibility.DEFAULT).withFieldVisibility(JsonAutoDetect.Visibility.DEFAULT).withIsGetterVisibility(JsonAutoDetect.Visibility.DEFAULT);

        private Introspector() {
        }

        public VisibilityChecker<?> findAutoDetectVisibility(AnnotatedClass ac, VisibilityChecker<?> checker) {
            if (ac.getRawType().isRecord()) {
                JsonAutoDetect overrideAnnotation = ac.getRawType().getAnnotation(JsonAutoDetect.class);
                if (overrideAnnotation != null) {
                    return VisibilityChecker.Std.construct((JsonAutoDetect.Value)JsonAutoDetect.Value.from((JsonAutoDetect)overrideAnnotation));
                }
                if (ac.getRawType().isAnnotationPresent(LegacyRecordIntrospection.class)) {
                    return RECORD_VISIBILITY_CHECKER;
                }
                return new RecordVisibilityChecker(ac.getRawType().asSubclass(Record.class));
            }
            return checker;
        }

        public Version version() {
            return Version.unknownVersion();
        }
    }

    private static class RecordVisibilityChecker
    implements VisibilityChecker<RecordVisibilityChecker> {
        private final Set<String> componentNames;

        public RecordVisibilityChecker(Class<? extends Record> recordClass) {
            this.componentNames = (Set)Stream.of(recordClass.getRecordComponents()).map(RecordComponent::getName).collect(ImmutableSet.toImmutableSet());
        }

        public RecordVisibilityChecker with(JsonAutoDetect annotation) {
            throw new UnsupportedOperationException();
        }

        public RecordVisibilityChecker withOverrides(JsonAutoDetect.Value value) {
            throw new UnsupportedOperationException();
        }

        public RecordVisibilityChecker with(JsonAutoDetect.Visibility visibility) {
            throw new UnsupportedOperationException();
        }

        public RecordVisibilityChecker withVisibility(PropertyAccessor propertyAccessor, JsonAutoDetect.Visibility visibility) {
            throw new UnsupportedOperationException();
        }

        public RecordVisibilityChecker withGetterVisibility(JsonAutoDetect.Visibility visibility) {
            throw new UnsupportedOperationException();
        }

        public RecordVisibilityChecker withIsGetterVisibility(JsonAutoDetect.Visibility visibility) {
            throw new UnsupportedOperationException();
        }

        public RecordVisibilityChecker withSetterVisibility(JsonAutoDetect.Visibility visibility) {
            throw new UnsupportedOperationException();
        }

        public RecordVisibilityChecker withCreatorVisibility(JsonAutoDetect.Visibility visibility) {
            throw new UnsupportedOperationException();
        }

        public RecordVisibilityChecker withFieldVisibility(JsonAutoDetect.Visibility visibility) {
            throw new UnsupportedOperationException();
        }

        public boolean isGetterVisible(Method method) {
            if (!Modifier.isPublic(method.getModifiers())) {
                return false;
            }
            return this.componentNames.contains(method.getName());
        }

        public boolean isGetterVisible(AnnotatedMethod annotatedMethod) {
            return this.isGetterVisible(annotatedMethod.getAnnotated());
        }

        public boolean isIsGetterVisible(Method method) {
            return false;
        }

        public boolean isIsGetterVisible(AnnotatedMethod annotatedMethod) {
            return false;
        }

        public boolean isSetterVisible(Method method) {
            return false;
        }

        public boolean isSetterVisible(AnnotatedMethod annotatedMethod) {
            return false;
        }

        public boolean isCreatorVisible(Member member) {
            return true;
        }

        public boolean isCreatorVisible(AnnotatedMember annotatedMember) {
            return true;
        }

        public boolean isFieldVisible(Field field) {
            return false;
        }

        public boolean isFieldVisible(AnnotatedField field) {
            return false;
        }
    }

    @Deprecated(forRemoval=true)
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface LegacyRecordIntrospection {
    }
}

