/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.airlift.slice.Preconditions;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Objects;

public class BasicSliceOutput
extends SliceOutput {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(BasicSliceOutput.class);
    private final Slice slice;
    private int size;

    protected BasicSliceOutput(Slice slice) {
        this.slice = Objects.requireNonNull(slice, "slice is null");
    }

    @Override
    public void reset() {
        this.size = 0;
    }

    @Override
    public void reset(int position) {
        Preconditions.checkArgument(position >= 0, "position is negative");
        Preconditions.checkArgument(position <= this.size, "position is larger than size");
        this.size = position;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public long getRetainedSize() {
        return this.slice.getRetainedSize() + (long)INSTANCE_SIZE;
    }

    @Override
    public boolean isWritable() {
        return this.writableBytes() > 0;
    }

    @Override
    public int writableBytes() {
        return this.slice.length() - this.size;
    }

    @Override
    public void writeByte(int value) {
        this.slice.setByte(this.size, value);
        ++this.size;
    }

    @Override
    public void writeShort(int value) {
        this.slice.setShort(this.size, value);
        this.size += 2;
    }

    @Override
    public void writeInt(int value) {
        this.slice.setInt(this.size, value);
        this.size += 4;
    }

    @Override
    public void writeLong(long value) {
        this.slice.setLong(this.size, value);
        this.size += 8;
    }

    @Override
    public void writeFloat(float value) {
        this.slice.setFloat(this.size, value);
        this.size += 4;
    }

    @Override
    public void writeDouble(double value) {
        this.slice.setDouble(this.size, value);
        this.size += 8;
    }

    @Override
    public void writeBytes(byte[] source, int sourceIndex, int length) {
        this.slice.setBytes(this.size, source, sourceIndex, length);
        this.size += length;
    }

    @Override
    public void writeBytes(byte[] source) {
        this.writeBytes(source, 0, source.length);
    }

    @Override
    public void writeShorts(short[] source, int sourceIndex, int length) {
        this.slice.setShorts(this.size, source, sourceIndex, length);
        this.size += length * 2;
    }

    @Override
    public void writeInts(int[] source, int sourceIndex, int length) {
        this.slice.setInts(this.size, source, sourceIndex, length);
        this.size += length * 4;
    }

    @Override
    public void writeLongs(long[] source, int sourceIndex, int length) {
        this.slice.setLongs(this.size, source, sourceIndex, length);
        this.size += length * 8;
    }

    @Override
    public void writeFloats(float[] source, int sourceIndex, int length) {
        this.slice.setFloats(this.size, source, sourceIndex, length);
        this.size += length * 4;
    }

    @Override
    public void writeDoubles(double[] source, int sourceIndex, int length) {
        this.slice.setDoubles(this.size, source, sourceIndex, length);
        this.size += length * 8;
    }

    @Override
    public void writeBytes(Slice source) {
        this.writeBytes(source, 0, source.length());
    }

    @Override
    public void writeBytes(Slice source, int sourceIndex, int length) {
        this.slice.setBytes(this.size, source, sourceIndex, length);
        this.size += length;
    }

    @Override
    public void writeBytes(InputStream in, int length) throws IOException {
        this.slice.setBytes(this.size, in, length);
        this.size += length;
    }

    @Override
    public BasicSliceOutput appendLong(long value) {
        this.writeLong(value);
        return this;
    }

    @Override
    public SliceOutput appendDouble(double value) {
        this.writeDouble(value);
        return this;
    }

    @Override
    public BasicSliceOutput appendInt(int value) {
        this.writeInt(value);
        return this;
    }

    @Override
    public BasicSliceOutput appendShort(int value) {
        this.writeShort(value);
        return this;
    }

    @Override
    public BasicSliceOutput appendByte(int value) {
        this.writeByte(value);
        return this;
    }

    @Override
    public BasicSliceOutput appendBytes(byte[] source, int sourceIndex, int length) {
        this.write(source, sourceIndex, length);
        return this;
    }

    @Override
    public BasicSliceOutput appendBytes(byte[] source) {
        this.writeBytes(source);
        return this;
    }

    @Override
    public BasicSliceOutput appendBytes(Slice slice) {
        this.writeBytes(slice);
        return this;
    }

    @Override
    public Slice slice() {
        return this.slice.slice(0, this.size);
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Slice getUnderlyingSlice() {
        return this.slice;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("BasicSliceOutput{");
        builder.append("size=").append(this.size);
        builder.append(", capacity=").append(this.slice.length());
        builder.append('}');
        return builder.toString();
    }

    @Override
    public String toString(Charset charset) {
        return this.slice.toString(0, this.size, charset);
    }
}

