/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hdfs.authentication;

import com.google.inject.Inject;
import io.trino.hdfs.authentication.ForHdfs;
import io.trino.hdfs.authentication.HadoopAuthentication;
import io.trino.hdfs.authentication.HdfsAuthentication;
import io.trino.plugin.base.security.UserNameProvider;
import io.trino.spi.security.ConnectorIdentity;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Objects;
import org.apache.hadoop.security.UserGroupInformation;

public class ImpersonatingHdfsAuthentication
implements HdfsAuthentication {
    private final HadoopAuthentication hadoopAuthentication;
    private final UserNameProvider userNameProvider;

    @Inject
    public ImpersonatingHdfsAuthentication(@ForHdfs HadoopAuthentication hadoopAuthentication, @ForHdfs UserNameProvider userNameProvider) {
        this.hadoopAuthentication = Objects.requireNonNull(hadoopAuthentication);
        this.userNameProvider = Objects.requireNonNull(userNameProvider);
    }

    @Override
    public <T> T doAs(ConnectorIdentity identity, HdfsAuthentication.ExceptionAction<T> action) throws IOException {
        try {
            return (T)this.createProxyUser(this.userNameProvider.get(identity)).callAs(action::run);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
    }

    private UserGroupInformation createProxyUser(String user) {
        return UserGroupInformation.createProxyUser((String)user, (UserGroupInformation)this.hadoopAuthentication.getUserGroupInformation());
    }
}

