/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.hdfs;

import io.airlift.slice.Slice;
import io.trino.filesystem.TrinoInput;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.hdfs.HdfsFileSystem;
import io.trino.hdfs.FSDataInputStreamTail;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.fs.FSDataInputStream;

class HdfsInput
implements TrinoInput {
    private final FSDataInputStream stream;
    private final TrinoInputFile inputFile;
    private boolean closed;

    public HdfsInput(FSDataInputStream stream, TrinoInputFile inputFile) {
        this.stream = Objects.requireNonNull(stream, "stream is null");
        this.inputFile = Objects.requireNonNull(inputFile, "inputFile is null");
    }

    public void readFully(long position, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        this.ensureOpen();
        try {
            this.stream.readFully(position, buffer, bufferOffset, bufferLength);
        }
        catch (FileNotFoundException e) {
            throw HdfsFileSystem.withCause(new FileNotFoundException("File %s not found: %s".formatted(this.toString(), e.getMessage())), e);
        }
        catch (IOException e) {
            throw new IOException("Read exactly %s bytes at position %s of file %s failed: %s".formatted(bufferLength, position, this.toString(), e.getMessage()), e);
        }
    }

    public int readTail(byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        this.ensureOpen();
        try {
            Slice tail = FSDataInputStreamTail.readTail(this.toString(), this.inputFile.length(), this.stream, bufferLength).getTailSlice();
            tail.getBytes(0, buffer, bufferOffset, tail.length());
            return tail.length();
        }
        catch (FileNotFoundException e) {
            throw HdfsFileSystem.withCause(new FileNotFoundException("File %s not found: %s".formatted(this.toString(), e.getMessage())), e);
        }
        catch (IOException e) {
            throw new IOException("Read %s tail bytes of file %s failed: %s".formatted(bufferLength, this.toString(), e.getMessage()), e);
        }
    }

    public void close() throws IOException {
        this.closed = true;
        this.stream.close();
    }

    public String toString() {
        return this.inputFile.toString();
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Output stream closed: " + String.valueOf(this));
        }
    }
}

