/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.hdfs;

import com.google.inject.Inject;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.hdfs.HdfsFileSystem;
import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.hdfs.TrinoHdfsFileSystemStats;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Objects;

public class HdfsFileSystemFactory
implements TrinoFileSystemFactory {
    private final HdfsEnvironment environment;
    private final TrinoHdfsFileSystemStats fileSystemStats;

    @Inject
    public HdfsFileSystemFactory(HdfsEnvironment environment, TrinoHdfsFileSystemStats fileSystemStats) {
        this.environment = Objects.requireNonNull(environment, "environment is null");
        this.fileSystemStats = Objects.requireNonNull(fileSystemStats, "fileSystemStats is null");
    }

    public TrinoFileSystem create(ConnectorIdentity identity) {
        return new HdfsFileSystem(this.environment, new HdfsContext(identity), this.fileSystemStats);
    }
}

