/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.trino.spi.block.ArrayBlock;
import io.trino.spi.block.ArrayValueBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.Type;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;

public class ArrayBlockBuilder
implements BlockBuilder {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(ArrayBlockBuilder.class);
    private static final int SIZE_IN_BYTES_PER_POSITION = 5;
    private int positionCount;
    @Nullable
    private final BlockBuilderStatus blockBuilderStatus;
    private boolean initialized;
    private final int initialEntryCount;
    private int[] offsets = new int[1];
    private boolean[] valueIsNull = new boolean[0];
    private boolean hasNullValue;
    private boolean hasNonNullValue;
    private final BlockBuilder values;
    private boolean currentEntryOpened;
    private long retainedSizeInBytes;

    public ArrayBlockBuilder(BlockBuilder valuesBlock, BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        this(blockBuilderStatus, valuesBlock, expectedEntries);
    }

    public ArrayBlockBuilder(Type elementType, BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        this(blockBuilderStatus, elementType.createBlockBuilder(blockBuilderStatus, expectedEntries, expectedBytesPerEntry), expectedEntries);
    }

    public ArrayBlockBuilder(Type elementType, BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        this(blockBuilderStatus, elementType.createBlockBuilder(blockBuilderStatus, expectedEntries), expectedEntries);
    }

    private ArrayBlockBuilder(@Nullable BlockBuilderStatus blockBuilderStatus, BlockBuilder values, int expectedEntries) {
        this.blockBuilderStatus = blockBuilderStatus;
        this.values = Objects.requireNonNull(values, "values is null");
        this.initialEntryCount = Math.max(expectedEntries, 1);
        this.updateRetainedSize();
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        return this.values.getSizeInBytes() + 5L * (long)this.positionCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes + this.values.getRetainedSizeInBytes();
    }

    public <E extends Throwable> void buildEntry(ArrayValueBuilder<E> builder) throws E {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Expected current entry to be closed but was opened");
        }
        this.currentEntryOpened = true;
        builder.build(this.values);
        this.entryAdded(false);
        this.currentEntryOpened = false;
    }

    @Override
    public void append(ValueBlock block, int position) {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Current entry must be closed before a null can be written");
        }
        ArrayBlock arrayBlock = (ArrayBlock)block;
        if (block.isNull(position)) {
            this.entryAdded(true);
            return;
        }
        int offsetBase = arrayBlock.getOffsetBase();
        int[] offsets = arrayBlock.getOffsets();
        int startOffset = offsets[offsetBase + position];
        int length = offsets[offsetBase + position + 1] - startOffset;
        BlockUtil.appendRawBlockRange(arrayBlock.getRawElementBlock(), startOffset, length, this.values);
        this.entryAdded(false);
    }

    @Override
    public void appendRepeated(ValueBlock block, int position, int count) {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Current entry must be closed before a null can be written");
        }
        for (int i = 0; i < count; ++i) {
            this.append(block, position);
        }
    }

    @Override
    public void appendRange(ValueBlock block, int offset, int length) {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Current entry must be closed before a null can be written");
        }
        this.ensureCapacity(this.positionCount + length);
        ArrayBlock arrayBlock = (ArrayBlock)block;
        int rawOffsetBase = arrayBlock.getOffsetBase();
        int[] rawOffsets = arrayBlock.getOffsets();
        int startOffset = rawOffsets[rawOffsetBase + offset];
        int endOffset = rawOffsets[rawOffsetBase + offset + length];
        BlockUtil.appendRawBlockRange(arrayBlock.getRawElementBlock(), startOffset, endOffset - startOffset, this.values);
        for (int i = 0; i < length; ++i) {
            int entrySize = rawOffsets[rawOffsetBase + offset + i + 1] - rawOffsets[rawOffsetBase + offset + i];
            this.offsets[this.positionCount + i + 1] = this.offsets[this.positionCount + i] + entrySize;
        }
        boolean[] rawValueIsNull = arrayBlock.getRawValueIsNull();
        if (rawValueIsNull != null) {
            for (int i = 0; i < length; ++i) {
                if (rawValueIsNull[rawOffsetBase + offset + i]) {
                    this.valueIsNull[this.positionCount + i] = true;
                    this.hasNullValue = true;
                    continue;
                }
                this.hasNonNullValue = true;
            }
        } else {
            this.hasNonNullValue = true;
        }
        this.positionCount += length;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(length * 5);
        }
    }

    @Override
    public void appendPositions(ValueBlock block, int[] positions, int offset, int length) {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Current entry must be closed before a null can be written");
        }
        for (int i = 0; i < length; ++i) {
            this.append(block, positions[offset + i]);
        }
    }

    @Override
    public BlockBuilder appendNull() {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Current entry must be closed before a null can be written");
        }
        this.entryAdded(true);
        return this;
    }

    @Override
    public void resetTo(int position) {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Expected current entry to be closed but was opened");
        }
        Objects.checkIndex(position, this.positionCount + 1);
        this.positionCount = position;
        this.values.resetTo(this.offsets[this.positionCount]);
    }

    private void entryAdded(boolean isNull) {
        this.ensureCapacity(this.positionCount + 1);
        this.offsets[this.positionCount + 1] = this.values.getPositionCount();
        this.valueIsNull[this.positionCount] = isNull;
        this.hasNullValue |= isNull;
        this.hasNonNullValue |= !isNull;
        ++this.positionCount;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(5);
        }
    }

    private void ensureCapacity(int capacity) {
        int newSize;
        if (this.valueIsNull.length >= capacity) {
            return;
        }
        if (this.initialized) {
            newSize = BlockUtil.calculateNewArraySize(capacity);
        } else {
            newSize = this.initialEntryCount;
            this.initialized = true;
        }
        newSize = Math.max(newSize, capacity);
        this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
        this.offsets = Arrays.copyOf(this.offsets, newSize + 1);
        this.updateRetainedSize();
    }

    private void updateRetainedSize() {
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])this.valueIsNull) + SizeOf.sizeOf((int[])this.offsets);
        if (this.blockBuilderStatus != null) {
            this.retainedSizeInBytes += (long)BlockBuilderStatus.INSTANCE_SIZE;
        }
    }

    @Override
    public Block build() {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Current entry must be closed before the block can be built");
        }
        if (!this.hasNonNullValue) {
            return this.nullRle(this.positionCount);
        }
        return this.buildValueBlock();
    }

    @Override
    public ValueBlock buildValueBlock() {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Current entry must be closed before the block can be built");
        }
        return ArrayBlock.createArrayBlockInternal(0, this.positionCount, this.hasNullValue ? this.valueIsNull : null, this.offsets, this.values.build());
    }

    @Override
    public BlockBuilder newBlockBuilderLike(int expectedEntries, BlockBuilderStatus blockBuilderStatus) {
        return new ArrayBlockBuilder(blockBuilderStatus, this.values.newBlockBuilderLike(blockBuilderStatus), expectedEntries);
    }

    public String toString() {
        return "ArrayBlockBuilder{positionCount=" + this.getPositionCount() + "}";
    }

    private Block nullRle(int positionCount) {
        ArrayBlock nullValueBlock = ArrayBlock.createArrayBlockInternal(0, 1, new boolean[]{true}, new int[]{0, 0}, this.values.newBlockBuilderLike(null).build());
        return RunLengthEncodedBlock.create(nullValueBlock, positionCount);
    }
}

