/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.ErrorType;
import java.util.Objects;

public final class ErrorCode {
    private final int code;
    private final String name;
    private final ErrorType type;
    private final boolean fatal;

    public ErrorCode(@JsonProperty(value="code") int code, @JsonProperty(value="name") String name, @JsonProperty(value="type") ErrorType type) {
        this(code, name, type, type == ErrorType.USER_ERROR);
    }

    @JsonCreator
    public ErrorCode(@JsonProperty(value="code") int code, @JsonProperty(value="name") String name, @JsonProperty(value="type") ErrorType type, @JsonProperty(value="fatal") boolean fatal) {
        if (code < 0) {
            throw new IllegalArgumentException("code is negative");
        }
        this.code = code;
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.fatal = fatal;
    }

    @JsonProperty
    public int getCode() {
        return this.code;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public ErrorType getType() {
        return this.type;
    }

    @JsonProperty
    public boolean isFatal() {
        return this.fatal;
    }

    public String toString() {
        return this.name + ":" + this.code;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ErrorCode that = (ErrorCode)obj;
        return this.code == that.code;
    }

    public int hashCode() {
        return Objects.hash(this.code);
    }
}

