/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.type;

import io.trino.plugin.base.type.AbstractTrinoTimestampEncoder;
import io.trino.plugin.base.type.DecodedTimestamp;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Timestamps;
import org.joda.time.DateTimeZone;

class ShortTimestampEncoder
extends AbstractTrinoTimestampEncoder<Long> {
    ShortTimestampEncoder(TimestampType type, DateTimeZone timeZone) {
        super(type, timeZone);
    }

    @Override
    public void write(DecodedTimestamp decodedTimestamp, BlockBuilder blockBuilder) {
        Long micros = this.getTimestamp(decodedTimestamp);
        this.type.writeLong(blockBuilder, micros.longValue());
    }

    @Override
    public Long getTimestamp(DecodedTimestamp decodedTimestamp) {
        long micros = this.timeZone != DateTimeZone.UTC ? Math.multiplyExact(this.timeZone.convertUTCToLocal(Math.multiplyExact(decodedTimestamp.epochSeconds(), 1000)), 1000) : Math.multiplyExact(decodedTimestamp.epochSeconds(), 1000000);
        int nanosOfSecond = (int)Timestamps.round((long)decodedTimestamp.nanosOfSecond(), (int)(9 - this.type.getPrecision()));
        return Math.addExact(micros, (long)(nanosOfSecond / 1000));
    }
}

