/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.configuration.secrets;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.configuration.ConfigurationUtils;
import io.airlift.configuration.TomlConfiguration;
import io.airlift.configuration.secrets.SecretsPluginClassLoader;
import io.airlift.configuration.secrets.SecretsPluginConfig;
import io.airlift.configuration.secrets.SecretsResolver;
import io.airlift.configuration.secrets.ThreadContextClassLoader;
import io.airlift.configuration.secrets.env.EnvironmentVariableSecretsPlugin;
import io.airlift.log.Logger;
import io.airlift.spi.secrets.SecretProvider;
import io.airlift.spi.secrets.SecretProviderFactory;
import io.airlift.spi.secrets.SecretsPlugin;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public final class SecretsPluginManager {
    private static final ImmutableList<String> SPI_PACKAGES = ImmutableList.builder().add((Object)"io.airlift.spi.secrets").build();
    private static final Logger log = Logger.get(SecretsPluginManager.class);
    private static final String SECRETS_PROVIDER_NAME_PROPERTY = "secrets-provider.name";
    private static final Pattern SECRETS_PROVIDER_NAME_PATTERN = Pattern.compile("[a-z][a-z0-9_-]*");
    private final Map<String, SecretProviderFactory> secretsProviderFactories = new ConcurrentHashMap<String, SecretProviderFactory>();
    private final AtomicReference<Map<String, SecretProvider>> secretsProviders = new AtomicReference<ImmutableMap>(ImmutableMap.of());
    private final File installedSecretPluginsDir;
    private final TomlConfiguration tomlConfiguration;

    public SecretsPluginManager(TomlConfiguration tomlConfiguration) {
        this.tomlConfiguration = Objects.requireNonNull(tomlConfiguration, "tomlConfiguration is null");
        ConfigurationFactory configurationFactory = new ConfigurationFactory(tomlConfiguration.getParentConfiguration());
        SecretsPluginConfig config = configurationFactory.build(SecretsPluginConfig.class);
        this.installedSecretPluginsDir = config.getSecretsPluginsDir();
    }

    public void installPlugins() {
        this.installSecretsPlugin(new EnvironmentVariableSecretsPlugin());
        SecretsPluginManager.listFiles(this.installedSecretPluginsDir).stream().filter(File::isDirectory).forEach(file -> this.loadConfigurationResolvers(file.getAbsolutePath(), () -> SecretsPluginManager.createClassLoader(file.getName(), SecretsPluginManager.buildClassPath(file))));
    }

    @VisibleForTesting
    void installSecretsPlugin(SecretsPlugin secretsPlugin) {
        secretsPlugin.getSecretProviderFactories().forEach(this::addSecretProviderFactory);
    }

    private void addSecretProviderFactory(SecretProviderFactory secretProviderFactory) {
        Verify.verify((boolean)SECRETS_PROVIDER_NAME_PATTERN.matcher(secretProviderFactory.getName()).matches(), (String)"Secret provider name '%s' doesn't match pattern '%s'", (Object)secretProviderFactory.getName(), (Object)SECRETS_PROVIDER_NAME_PATTERN);
        this.secretsProviderFactories.put(secretProviderFactory.getName(), secretProviderFactory);
    }

    public void load() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String namespace : this.tomlConfiguration.getNamespaces()) {
            Map<String, String> properties = new HashMap<String, String>(this.tomlConfiguration.getNamespaceConfiguration(namespace));
            String name = (properties = ConfigurationUtils.replaceEnvironmentVariables(properties)).remove(SECRETS_PROVIDER_NAME_PROPERTY);
            Preconditions.checkState((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (String)"Configuration resolver configuration '%s' does not contain '%s'", (Object)namespace, (Object)SECRETS_PROVIDER_NAME_PROPERTY);
            builder.put((Object)namespace, (Object)this.loadConfigProvider(name, properties));
        }
        this.secretsProviders.set((Map<String, SecretProvider>)builder.buildOrThrow());
    }

    public SecretsResolver getSecretsResolver() {
        return new SecretsResolver(this.secretsProviders.get());
    }

    private void loadConfigurationResolvers(String plugin, Supplier<SecretsPluginClassLoader> createClassLoader) {
        log.info("-- Loading plugin %s --", new Object[]{plugin});
        SecretsPluginClassLoader pluginClassLoader = createClassLoader.get();
        log.debug("Classpath for plugin:");
        for (URL url : pluginClassLoader.getURLs()) {
            log.debug("    %s", new Object[]{url.getPath()});
        }
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(pluginClassLoader);){
            this.loadConfigurationPlugin(pluginClassLoader);
        }
        log.info("-- Finished loading plugin %s --", new Object[]{plugin});
    }

    private void loadConfigurationPlugin(SecretsPluginClassLoader pluginClassLoader) {
        ServiceLoader<SecretsPlugin> serviceLoader = ServiceLoader.load(SecretsPlugin.class, pluginClassLoader);
        ImmutableList plugins = ImmutableList.copyOf(serviceLoader);
        Preconditions.checkState((!plugins.isEmpty() ? 1 : 0) != 0, (String)"No service providers of type %s in the classpath: %s", (Object)SecretsPlugin.class.getName(), Arrays.asList(pluginClassLoader.getURLs()));
        for (SecretsPlugin plugin : plugins) {
            log.info("Installing %s", new Object[]{plugin.getClass().getName()});
            this.installSecretsPlugin(plugin);
        }
    }

    private SecretProvider loadConfigProvider(String configProviderName, Map<String, String> properties) {
        SecretProvider secretProvider;
        log.info("-- Loading secret provider --");
        SecretProviderFactory factory = this.secretsProviderFactories.get(configProviderName);
        Preconditions.checkState((factory != null ? 1 : 0) != 0, (String)"Secret provider '%s' is not registered", (Object)configProviderName);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(factory.getClass().getClassLoader());){
            secretProvider = factory.createSecretProvider((Map)ImmutableMap.copyOf(properties));
        }
        log.info("-- Loaded secret provider %s --", new Object[]{configProviderName});
        return secretProvider;
    }

    private static List<URL> buildClassPath(File path) {
        return (List)SecretsPluginManager.listFiles(path).stream().map(SecretsPluginManager::fileToUrl).collect(ImmutableList.toImmutableList());
    }

    private static SecretsPluginClassLoader createClassLoader(String pluginName, List<URL> urls) {
        ClassLoader parent = SecretsPluginManager.class.getClassLoader();
        return new SecretsPluginClassLoader(pluginName, urls, parent, (List<String>)SPI_PACKAGES);
    }

    private static List<File> listFiles(File path) {
        List list;
        block8: {
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path.toPath());
            try {
                list = (List)Streams.stream(directoryStream).map(Path::toFile).sorted().collect(ImmutableList.toImmutableList());
                if (directoryStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (directoryStream != null) {
                        try {
                            directoryStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            directoryStream.close();
        }
        return list;
    }

    private static URL fileToUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }
}

