/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.securityprovider.ldap;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import ru.cedrusdata.catalog.spi.CatalogResourceResolver;
import ru.cedrusdata.catalog.spi.exception.CatalogBadRequestException;

public class CatalogLdapSecurityProviderConfig {
    static final String URL = "url";
    static final String ALLOW_INSECURE = "allow-insecure";
    static final String SSL_KEYSTORE_PATH = "ssl-keystore-path";
    static final String SSL_KEYSTORE_PASSWORD = "ssl-keystore-password";
    static final String SSL_TRUSTSTORE_PATH = "ssl-truststore-path";
    static final String SSL_TRUSTSTORE_PASSWORD = "ssl-truststore-password";
    static final String TIMEOUT_CONNECT = "connect-timeout";
    static final String TIMEOUT_READ = "read-timeout";
    static final String IGNORE_REFERRALS = "ignore-referrals";
    static final String BIND_USER_DN = "bind-user-dn";
    static final String BIND_PASSWORD = "bind-password";
    static final String AUTH_USER_DN_PATTERN = "user-dn-pattern";
    static final String AUTH_USER_SEARCH_BASE = "user-search-base";
    static final String AUTH_USER_SEARCH_FILTER = "user-search-filter";
    static final String CACHE_TTL = "cache-ttl";
    static final String CACHE_MAX_SIZE = "cache-max-size";
    static final String USER_PLACEHOLDER = "${USER}";
    private String ldapUrl;
    private boolean allowInsecure;
    private String keystorePath;
    private String keystorePassword;
    private String trustStorePath;
    private String truststorePassword;
    private boolean ignoreReferrals;
    private long ldapConnectionTimeout;
    private long ldapReadTimeout;
    private String bindUser;
    private String bindPassword;
    private List<String> authUserDNPatterns = List.of();
    private String authUserSearchBase;
    private String authUserSearchFilter;
    private long cacheTtl = TimeUnit.MINUTES.toMillis(5L);
    private int cacheMaxSize = 1000;

    public String getLdapUrl() {
        return this.ldapUrl;
    }

    @Config(value="url")
    @ConfigDescription(value="URL of the LDAP server")
    public CatalogLdapSecurityProviderConfig setLdapUrl(String url) {
        this.ldapUrl = url;
        return this;
    }

    public boolean isAllowInsecure() {
        return this.allowInsecure;
    }

    @Config(value="allow-insecure")
    @ConfigDescription(value="Allow insecure connection to the LDAP server")
    public CatalogLdapSecurityProviderConfig setAllowInsecure(boolean allowInsecure) {
        this.allowInsecure = allowInsecure;
        return this;
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    @Config(value="ssl-keystore-path")
    @ConfigDescription(value="Path to the PEM or JKS key store")
    public CatalogLdapSecurityProviderConfig setKeystorePath(String path) {
        this.keystorePath = path;
        return this;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    @Config(value="ssl-keystore-password")
    @ConfigSecuritySensitive
    @ConfigDescription(value="Password for the key store")
    public CatalogLdapSecurityProviderConfig setKeystorePassword(String password) {
        this.keystorePassword = password;
        return this;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    @Config(value="ssl-truststore-path")
    @ConfigDescription(value="Path to the PEM or JKS trust store")
    public CatalogLdapSecurityProviderConfig setTrustStorePath(String path) {
        this.trustStorePath = path;
        return this;
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    @Config(value="ssl-truststore-password")
    @ConfigSecuritySensitive
    @ConfigDescription(value="Password for the trust store")
    public CatalogLdapSecurityProviderConfig setTruststorePassword(String password) {
        this.truststorePassword = password;
        return this;
    }

    public boolean isIgnoreReferrals() {
        return this.ignoreReferrals;
    }

    @Config(value="ignore-referrals")
    @ConfigDescription(value="Referrals allow finding entries across multiple LDAP servers. Ignore them to only search within 1 LDAP server")
    public CatalogLdapSecurityProviderConfig setIgnoreReferrals(boolean ignoreReferrals) {
        this.ignoreReferrals = ignoreReferrals;
        return this;
    }

    public long getLdapConnectionTimeout() {
        return this.ldapConnectionTimeout;
    }

    @Config(value="connect-timeout")
    @ConfigDescription(value="Timeout for establishing a connection in milliseconds")
    public CatalogLdapSecurityProviderConfig setLdapConnectionTimeout(long ldapConnectionTimeout) {
        this.ldapConnectionTimeout = ldapConnectionTimeout;
        return this;
    }

    public long getLdapReadTimeout() {
        return this.ldapReadTimeout;
    }

    @Config(value="read-timeout")
    @ConfigDescription(value="Timeout for reading data from LDAP in milliseconds")
    public CatalogLdapSecurityProviderConfig setLdapReadTimeout(long ldapReadTimeout) {
        this.ldapReadTimeout = ldapReadTimeout;
        return this;
    }

    public String getBindUser() {
        return this.bindUser;
    }

    @Config(value="bind-user-dn")
    @ConfigDescription(value="User used to bind to the LDAP server and search for the users being authenticated")
    public CatalogLdapSecurityProviderConfig setBindUser(String bindUser) {
        this.bindUser = bindUser;
        return this;
    }

    public String getBindPassword() {
        return this.bindPassword;
    }

    @Config(value="bind-password")
    @ConfigDescription(value="Bind user password")
    @ConfigSecuritySensitive
    public CatalogLdapSecurityProviderConfig setBindPassword(String bindPassword) {
        this.bindPassword = bindPassword;
        return this;
    }

    public List<String> getAuthUserDNPatterns() {
        return this.authUserDNPatterns;
    }

    public CatalogLdapSecurityProviderConfig setAuthUserDNPatterns(List<String> authUserDNPatterns) {
        this.authUserDNPatterns = Objects.requireNonNull(authUserDNPatterns, "authUserDNPatterns is null");
        return this;
    }

    @Config(value="user-dn-pattern")
    @ConfigDescription(value="Pattern for searching user distinguished name, must contain ${USER} placeholder. Multiple patterns can be separated by a colon. Example: cn=${USER},dc=example,dc=com")
    public CatalogLdapSecurityProviderConfig setAuthUserDNPatterns(String authUserDNPatterns) {
        this.authUserDNPatterns = CatalogLdapSecurityProviderConfig.splitToList(authUserDNPatterns);
        return this;
    }

    public String getAuthUserSearchBase() {
        return this.authUserSearchBase;
    }

    @Config(value="user-search-base")
    @ConfigDescription(value="Base DN that should be used for the user search")
    public CatalogLdapSecurityProviderConfig setAuthUserSearchBase(String authUserSearchBase) {
        this.authUserSearchBase = authUserSearchBase;
        return this;
    }

    public String getAuthUserSearchFilter() {
        return this.authUserSearchFilter;
    }

    @Config(value="user-search-filter")
    @ConfigDescription(value="Filter used to find users, must contain ${USER} placeholder. Example: (&(objectClass=inetOrgPerson)(uid=${USER}))")
    public CatalogLdapSecurityProviderConfig setAuthUserSearchFilter(String authUserSearchFilter) {
        this.authUserSearchFilter = authUserSearchFilter;
        return this;
    }

    public long getCacheTtl() {
        return this.cacheTtl;
    }

    @Config(value="cache-ttl")
    @ConfigDescription(value="LDAP cache TTL in milliseconds, zero value disables caching. Defaults to 5 minutes")
    public CatalogLdapSecurityProviderConfig setCacheTtl(long cacheTtl) {
        this.cacheTtl = cacheTtl;
        return this;
    }

    public int getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    @Config(value="cache-max-size")
    @ConfigDescription(value="LDAP cache max size, zero value disables caching. Defaults to 1000")
    public CatalogLdapSecurityProviderConfig setCacheMaxSize(int cacheMaxSize) {
        this.cacheMaxSize = cacheMaxSize;
        return this;
    }

    private static List<String> splitToList(String value) {
        ArrayList<String> result = new ArrayList<String>();
        for (String pattern : value.split(":")) {
            result.add(pattern.trim());
        }
        return result;
    }

    public static Optional<String> validateProperties(Map<String, String> mutableConfig, CatalogResourceResolver resourceResolver) {
        boolean authUserSearchFilterPresent;
        for (String requiredProperty : List.of(URL, BIND_USER_DN, BIND_PASSWORD)) {
            String property = mutableConfig.get(requiredProperty);
            if (property != null && !property.isEmpty()) continue;
            return Optional.of(requiredProperty + " is required");
        }
        String url = mutableConfig.get(URL);
        if (!url.matches("^ldaps?://.*")) {
            return Optional.of("Invalid LDAP server URL. Expected ldap:// or ldaps://");
        }
        boolean allowInsecure = false;
        if (mutableConfig.containsKey(ALLOW_INSECURE)) {
            allowInsecure = Boolean.parseBoolean(mutableConfig.get(ALLOW_INSECURE));
        }
        if (!allowInsecure && !url.startsWith("ldaps://")) {
            return Optional.of("Connecting to the LDAP server without SSL enabled requires `allow-insecure=true`");
        }
        for (String pathProperty : List.of(SSL_KEYSTORE_PATH, SSL_TRUSTSTORE_PATH)) {
            if (!mutableConfig.containsKey(pathProperty)) continue;
            try {
                mutableConfig.put(pathProperty, resourceResolver.resolveResourcePath(mutableConfig.get(pathProperty), pathProperty));
            }
            catch (CatalogBadRequestException e) {
                return Optional.of(e.getOriginalMessage());
            }
        }
        if (mutableConfig.containsKey(SSL_KEYSTORE_PASSWORD) && !mutableConfig.containsKey(SSL_KEYSTORE_PATH)) {
            return Optional.of("Keystore password is provided without keystore path");
        }
        if (mutableConfig.containsKey(SSL_TRUSTSTORE_PASSWORD) && !mutableConfig.containsKey(SSL_TRUSTSTORE_PATH)) {
            return Optional.of("Truststore password is provided without truststore path");
        }
        for (String intParameter : List.of(TIMEOUT_CONNECT, TIMEOUT_READ, CACHE_MAX_SIZE)) {
            Optional<String> error = CatalogLdapSecurityProviderConfig.validateIntNonNegative(mutableConfig, intParameter);
            if (!error.isPresent()) continue;
            return error;
        }
        boolean authUserDNPatternPresent = mutableConfig.containsKey(AUTH_USER_DN_PATTERN);
        boolean authUserSearchBasePresent = mutableConfig.containsKey(AUTH_USER_SEARCH_BASE);
        if (authUserSearchBasePresent != (authUserSearchFilterPresent = mutableConfig.containsKey(AUTH_USER_SEARCH_FILTER))) {
            return Optional.of("Both user search base and user search filter must be provided together");
        }
        if (!authUserDNPatternPresent && !authUserSearchBasePresent) {
            return Optional.of("Either distinguished name pattern or user search base and filter must be provided");
        }
        if (authUserDNPatternPresent && authUserSearchBasePresent) {
            return Optional.of("Both distinguished name pattern and user search filter can not be provided together");
        }
        if (authUserDNPatternPresent) {
            for (String bindPattern : CatalogLdapSecurityProviderConfig.splitToList(mutableConfig.get(AUTH_USER_DN_PATTERN))) {
                if (bindPattern.contains(USER_PLACEHOLDER)) continue;
                return Optional.of(String.format("Distinguished name pattern must contain %s placeholder: %s", USER_PLACEHOLDER, bindPattern));
            }
        }
        if (authUserSearchFilterPresent && !mutableConfig.get(AUTH_USER_SEARCH_FILTER).contains(USER_PLACEHOLDER)) {
            return Optional.of(String.format("User search filter must contain %s placeholder: %s", USER_PLACEHOLDER, mutableConfig.get(AUTH_USER_SEARCH_FILTER)));
        }
        Optional<String> ttlError = CatalogLdapSecurityProviderConfig.validateLongNonNegative(mutableConfig, CACHE_TTL);
        if (ttlError.isPresent()) {
            return ttlError;
        }
        HashMap<String, String> unusedConfig = new HashMap<String, String>(mutableConfig);
        for (Class<CatalogLdapSecurityProviderConfig> configClass : List.of(CatalogLdapSecurityProviderConfig.class, CatalogLdapSecurityProviderConfig.class)) {
            for (Method method : configClass.getMethods()) {
                Config config = method.getAnnotation(Config.class);
                if (config == null) continue;
                unusedConfig.remove(config.value());
            }
        }
        if (!unusedConfig.isEmpty()) {
            return Optional.of(String.format("Unsupported property: \"%s\"", unusedConfig.keySet().iterator().next()));
        }
        return Optional.empty();
    }

    private static Optional<String> validateIntNonNegative(Map<String, String> config, String propertyName) {
        if (config.containsKey(propertyName)) {
            int value;
            try {
                value = Integer.parseInt(config.get(propertyName));
            }
            catch (NumberFormatException e) {
                return Optional.of(String.format("Cannot parse \"%s\" parameter: %s", propertyName, config.get(propertyName)));
            }
            if (value < 0) {
                return Optional.of(String.format("%s: must be greater than or equal to 0", propertyName));
            }
        }
        return Optional.empty();
    }

    private static Optional<String> validateLongNonNegative(Map<String, String> config, String propertyName) {
        if (config.containsKey(propertyName)) {
            long value;
            try {
                value = Long.parseLong(config.get(propertyName));
            }
            catch (NumberFormatException e) {
                return Optional.of(String.format("Cannot parse \"%s\" parameter: %s", propertyName, config.get(propertyName)));
            }
            if (value < 0L) {
                return Optional.of(String.format("%s: must be greater than or equal to 0", propertyName));
            }
        }
        return Optional.empty();
    }
}

