/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.engine.cedrusdata;

import java.util.Map;
import java.util.Optional;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import ru.cedrusdata.catalog.engine.cedrusdata.AbstractCatalogCedrusDataOperation;
import ru.cedrusdata.catalog.spi.computeengine.CatalogTable;

public class CatalogCedrusDataExpireSnapshotsOperation
extends AbstractCatalogCedrusDataOperation {
    private final int olderThanDays;

    public CatalogCedrusDataExpireSnapshotsOperation(Jdbi jdbi, CatalogTable table, int olderThanDays) {
        super(jdbi, table);
        this.olderThanDays = olderThanDays;
    }

    @Override
    protected Map<String, String> execute(Handle handle, String catalogName, String fullTableName) {
        String duration = this.olderThanDays + "d";
        handle.execute(String.format("SET SESSION %s.expire_snapshots_min_retention = '%s'", catalogName, duration), new Object[0]);
        Optional result = handle.createQuery(String.format("ALTER TABLE %s EXECUTE expire_snapshots(retention_threshold => '%s')", fullTableName, duration)).mapTo(String.class).findOne();
        handle.execute(String.format("RESET SESSION %s.expire_snapshots_min_retention", catalogName), new Object[0]);
        return CatalogCedrusDataExpireSnapshotsOperation.jsonToMap(result);
    }
}

