/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.filesystem.s3;

import com.google.inject.Inject;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.s3.S3FileSystem;
import io.trino.filesystem.s3.S3FileSystemLoader;
import io.trino.filesystem.s3.S3SecurityMappingResult;
import io.trino.spi.security.ConnectorIdentity;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import ru.cedrusdata.catalog.filesystem.common.CatalogTrinoFileSystem;
import ru.cedrusdata.catalog.filesystem.s3.CatalogS3FileSystemConfig;
import ru.cedrusdata.catalog.spi.exception.CatalogBadRequestException;
import ru.cedrusdata.catalog.spi.exception.CatalogInternalServerErrorException;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystem;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystemFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.services.s3.S3Client;

public class CatalogS3TrinoFileSystemFactory
implements CatalogFileSystemFactory {
    private static final String S3_SCHEME = "s3";
    private static final String S3A_SCHEME = "s3a";
    private final S3FileSystemLoader loader;
    private final boolean allowOverride;
    private final Lock commonClientLock = new ReentrantLock();
    private volatile S3Client commonClient;
    private boolean closed;

    @Inject
    public CatalogS3TrinoFileSystemFactory(S3FileSystemLoader loader, CatalogS3FileSystemConfig config) {
        this.loader = loader;
        this.allowOverride = config.isAllowOverride();
    }

    public CatalogFileSystem create(String user, Map<String, String> additionalProperties) {
        Optional<Object> closeable;
        S3FileSystem s3FileSystem;
        ConnectorIdentity identity = ConnectorIdentity.ofUser((String)user);
        if (additionalProperties.isEmpty()) {
            s3FileSystem = new S3FileSystem(this.loader.uploadExecutor(), this.createCommonClient(), this.loader.createPreSigner(), this.loader.context().withCredentials(identity));
            closeable = Optional.empty();
        } else {
            if (!this.allowOverride) {
                throw new CatalogBadRequestException(String.format("Cannot apply S3 properties override (please enable \"%s\" file system property)", "allow-override"));
            }
            S3SecurityMappingResult securityMappingResult = this.securityMappingForAdditionalProperties(additionalProperties);
            S3Client client = this.loader.clientFactory().create(Optional.of(securityMappingResult));
            s3FileSystem = new S3FileSystem(this.loader.uploadExecutor(), client, this.loader.createPreSigner(), this.loader.context().withCredentials(identity));
            closeable = Optional.of(() -> ((S3Client)client).close());
        }
        return new CatalogTrinoFileSystem((TrinoFileSystem)s3FileSystem, closeable);
    }

    private S3SecurityMappingResult securityMappingForAdditionalProperties(Map<String, String> additionalProperties) {
        String accessKey = additionalProperties.get("access-key");
        String secretKey = additionalProperties.get("secret-key");
        if (accessKey == null || accessKey.isEmpty() || secretKey == null || secretKey.isEmpty()) {
            throw new CatalogBadRequestException(String.format("\"%s\" and \"%s\" must be set for overridden S3 file system config", "access-key", "secret-key"));
        }
        if (additionalProperties.size() != 2) {
            throw new CatalogBadRequestException(String.format("Only \"%s\" and \"%s\" properties are supported for overridden S3 file system config", "access-key", "secret-key"));
        }
        AwsBasicCredentials credentials = AwsBasicCredentials.builder().accessKeyId(accessKey).secretAccessKey(secretKey).build();
        return new S3SecurityMappingResult(Optional.of(credentials), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public final Optional<String> isLocationValid(String location) {
        URI locationUri;
        try {
            locationUri = new URI(location);
        }
        catch (URISyntaxException e) {
            return Optional.of(String.format("Cannot parse file system location \"%s\": %s", location, e.getMessage()));
        }
        return this.isLocationValid(locationUri);
    }

    private Optional<String> isLocationValid(URI locationUri) {
        if (S3_SCHEME.equalsIgnoreCase(locationUri.getScheme()) || S3A_SCHEME.equalsIgnoreCase(locationUri.getScheme())) {
            return Optional.empty();
        }
        return Optional.of(String.format("File system location \"%s\" has invalid scheme (must be \"%s\")", locationUri, S3_SCHEME));
    }

    public void close() {
        this.commonClientLock.lock();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.commonClient != null) {
                this.commonClient.close();
            }
        }
        finally {
            this.commonClientLock.unlock();
        }
        this.loader.destroy();
    }

    private S3Client createCommonClient() {
        S3Client res = this.commonClient;
        if (res == null) {
            this.commonClientLock.lock();
            try {
                res = this.commonClient;
                if (res == null) {
                    if (this.closed) {
                        throw new CatalogInternalServerErrorException("File system has been stopped");
                    }
                    this.commonClient = res = this.loader.createClient();
                }
            }
            finally {
                this.commonClientLock.unlock();
            }
        }
        return res;
    }
}

