/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import com.google.inject.Inject;
import io.airlift.tracetoken.TraceTokenManager;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

class TraceTokenFilter
implements Filter {
    public static final String TRACETOKEN_HEADER = "X-Airlift-TraceToken";
    private final TraceTokenManager traceTokenManager;

    @Inject
    public TraceTokenFilter(TraceTokenManager traceTokenManager) {
        this.traceTokenManager = traceTokenManager;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String token = request.getHeader(TRACETOKEN_HEADER);
        if (token != null) {
            this.traceTokenManager.registerRequestToken(token);
        } else {
            this.traceTokenManager.createAndRegisterNewRequestToken();
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }
}

