/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import io.airlift.http.server.DoubleSummaryStats;
import io.airlift.http.server.jetty.RequestTiming;
import io.airlift.units.Duration;
import jakarta.annotation.Nullable;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.EventsHandler;
import org.eclipse.jetty.util.NanoTime;

class RequestTimingEventHandler
extends EventsHandler {
    static final String REQUEST_HANDLE_STARTED_ATTRIBUTE = RequestTimingEventHandler.class.getName() + ".handle_begin";
    static final String REQUEST_HANDLE_ENDED_ATTRIBUTE = RequestTimingEventHandler.class.getName() + ".handle_end";
    static final String RESPONSE_CONTENT_WRITE_BEGIN_ATTRIBUTE = RequestTimingEventHandler.class.getName() + ".content_write_begin";
    static final String RESPONSE_CONTENT_WRITE_END_ATTRIBUTE = RequestTimingEventHandler.class.getName() + ".content_write_end";
    private static final Object MARKER = new Object();

    public RequestTimingEventHandler(Handler handler) {
        super(handler);
    }

    protected void onResponseWrite(Request request, boolean last, ByteBuffer content) {
        request.setAttribute(RESPONSE_CONTENT_WRITE_BEGIN_ATTRIBUTE + "." + NanoTime.now(), MARKER);
    }

    protected void onResponseWriteComplete(Request request, Throwable failure) {
        request.setAttribute(RESPONSE_CONTENT_WRITE_END_ATTRIBUTE + "." + NanoTime.now(), MARKER);
    }

    protected void onBeforeHandling(Request request) {
        request.setAttribute(REQUEST_HANDLE_STARTED_ATTRIBUTE, (Object)NanoTime.now());
    }

    protected void onResponseTrailersComplete(Request request, HttpFields trailers) {
        request.setAttribute(REQUEST_HANDLE_ENDED_ATTRIBUTE, (Object)NanoTime.now());
    }

    public static RequestTiming timings(Request request) {
        long requestStarted = request.getBeginNanoTime();
        return new RequestTiming(Instant.ofEpochMilli(Request.getTimeStamp((Request)request)), RequestTimingEventHandler.elapsedMillis(requestStarted, request.getHeadersNanoTime()), RequestTimingEventHandler.elapsedMillis(requestStarted, RequestTimingEventHandler.getRequestBeginToHandle(request.asAttributeMap())), RequestTimingEventHandler.elapsedMillis(requestStarted, RequestTimingEventHandler.getFirstByte(request.asAttributeMap())), RequestTimingEventHandler.elapsedMillis(requestStarted, RequestTimingEventHandler.getLastByte(request.asAttributeMap())), RequestTimingEventHandler.elapsedMillis(requestStarted, RequestTimingEventHandler.getRequestBeginToEnd(request.asAttributeMap())), RequestTimingEventHandler.processContentTimestamps(RequestTimingEventHandler.getContentWriteBeginTimestamps(request.asAttributeMap())));
    }

    private static long getFirstByte(Map<String, Object> attributes) {
        List<Long> writeBeginTimestamps = RequestTimingEventHandler.getContentWriteBeginTimestamps(attributes);
        if (writeBeginTimestamps.isEmpty()) {
            return RequestTimingEventHandler.getRequestBeginToHandle(attributes);
        }
        return writeBeginTimestamps.getFirst();
    }

    private static long getLastByte(Map<String, Object> attributes) {
        List<Long> writeEndTimestamps = RequestTimingEventHandler.getContentWriteEndTimestamps(attributes);
        if (writeEndTimestamps.isEmpty()) {
            return RequestTimingEventHandler.getRequestBeginToEnd(attributes);
        }
        return writeEndTimestamps.getLast();
    }

    static long getRequestBeginToHandle(Map<String, Object> attributes) {
        return (Long)MoreObjects.firstNonNull((Object)attributes.get(REQUEST_HANDLE_STARTED_ATTRIBUTE), (Object)NanoTime.now());
    }

    static long getRequestBeginToEnd(Map<String, Object> attributes) {
        return (Long)MoreObjects.firstNonNull((Object)attributes.get(REQUEST_HANDLE_ENDED_ATTRIBUTE), (Object)NanoTime.now());
    }

    static List<Long> getContentWriteBeginTimestamps(Map<String, Object> attributes) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String attribute : attributes.keySet()) {
            if (!attribute.startsWith(RESPONSE_CONTENT_WRITE_BEGIN_ATTRIBUTE)) continue;
            String nanoTime = attribute.substring(RESPONSE_CONTENT_WRITE_BEGIN_ATTRIBUTE.length() + 1);
            builder.add((Object)Long.valueOf(nanoTime));
        }
        return Ordering.natural().sortedCopy((Iterable)builder.build());
    }

    static List<Long> getContentWriteEndTimestamps(Map<String, Object> attributes) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String attribute : attributes.keySet()) {
            if (!attribute.startsWith(RESPONSE_CONTENT_WRITE_END_ATTRIBUTE)) continue;
            String nanoTime = attribute.substring(RESPONSE_CONTENT_WRITE_END_ATTRIBUTE.length() + 1);
            builder.add((Object)Long.valueOf(nanoTime));
        }
        return Ordering.natural().sortedCopy((Iterable)builder.build());
    }

    @Nullable
    private static DoubleSummaryStats processContentTimestamps(List<Long> contentTimestamps) {
        Objects.requireNonNull(contentTimestamps, "contentTimestamps is null");
        if (contentTimestamps.isEmpty() || contentTimestamps.size() == 1) {
            return null;
        }
        DoubleSummaryStatistics statistics = new DoubleSummaryStatistics();
        long previousTimestamp = contentTimestamps.get(0);
        for (int i = 1; i < contentTimestamps.size(); ++i) {
            long timestamp = contentTimestamps.get(i);
            statistics.accept(RequestTimingEventHandler.elapsedMillis(timestamp, previousTimestamp).toMillis());
            previousTimestamp = timestamp;
        }
        return new DoubleSummaryStats(statistics);
    }

    private static Duration elapsedMillis(long beginNanoTime, long endNanoTime) {
        return Duration.succinctNanos((long)Math.max(0L, NanoTime.elapsed((long)beginNanoTime, (long)endNanoTime)));
    }
}

