/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import ch.qos.logback.core.LayoutBase;
import io.airlift.http.server.DoubleSummaryStats;
import io.airlift.http.server.HttpRequestEvent;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class HttpLogLayout
extends LayoutBase<HttpRequestEvent> {
    private static final DateTimeFormatter ISO_FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneId.systemDefault());

    public String doLayout(HttpRequestEvent event) {
        StringBuilder builder = new StringBuilder();
        String contentInterarrivalStats = null;
        DoubleSummaryStats stats = event.responseContentInterarrivalStats();
        if (stats != null) {
            contentInterarrivalStats = String.format("%.2f, %.2f, %.2f, %d", stats.getMin(), stats.getAverage(), stats.getMax(), stats.getCount());
        }
        builder.append(ISO_FORMATTER.format(event.timeStamp())).append('\t').append(event.clientAddress()).append('\t').append(event.method()).append('\t').append(event.requestUri()).append('\t').append(event.user()).append('\t').append(event.agent()).append('\t').append(event.responseCode()).append('\t').append(event.requestSize()).append('\t').append(event.responseSize()).append('\t').append(event.timeToLastByte()).append('\t').append(event.traceToken()).append('\t').append(event.protocolVersion()).append('\t').append(event.timeToDispatch()).append('\t').append(event.timeToCompletion()).append('\t').append(event.timeFromFirstToLastContent()).append('\t').append(contentInterarrivalStats).append('\n');
        return builder.toString();
    }
}

