/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.jetty;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.io.CountingInputStream;
import io.airlift.http.client.HeaderName;
import io.airlift.http.client.HttpVersion;
import io.airlift.http.client.Response;
import java.io.InputStream;
import org.eclipse.jetty.http.HttpFields;

class JettyResponse
implements Response {
    private final org.eclipse.jetty.client.Response response;
    private final CountingInputStream inputStream;
    private final ListMultimap<HeaderName, String> headers;

    public JettyResponse(org.eclipse.jetty.client.Response response, InputStream inputStream) {
        this.response = response;
        this.inputStream = new CountingInputStream(inputStream);
        this.headers = JettyResponse.toHeadersMap(response.getHeaders());
    }

    @Override
    public int getStatusCode() {
        return this.response.getStatus();
    }

    @Override
    public HttpVersion getHttpVersion() {
        return switch (this.response.getVersion()) {
            default -> throw new MatchException(null, null);
            case org.eclipse.jetty.http.HttpVersion.HTTP_0_9, org.eclipse.jetty.http.HttpVersion.HTTP_1_0, org.eclipse.jetty.http.HttpVersion.HTTP_1_1 -> HttpVersion.HTTP_1;
            case org.eclipse.jetty.http.HttpVersion.HTTP_2 -> HttpVersion.HTTP_2;
            case org.eclipse.jetty.http.HttpVersion.HTTP_3 -> HttpVersion.HTTP_3;
        };
    }

    @Override
    public ListMultimap<HeaderName, String> getHeaders() {
        return this.headers;
    }

    @Override
    public long getBytesRead() {
        return this.inputStream.getCount();
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("statusCode", this.getStatusCode()).add("headers", this.getHeaders()).toString();
    }

    private static ListMultimap<HeaderName, String> toHeadersMap(HttpFields headers) {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (String name : headers.getFieldNamesCollection()) {
            for (String value : headers.getValuesList(name)) {
                builder.put((Object)HeaderName.of(name), (Object)value);
            }
        }
        return builder.build();
    }
}

