/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.specific.SpecificData;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Objects;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ByteBuffers;

public class GenericManifestFile
implements ManifestFile,
StructLike,
IndexedRecord,
SpecificData.SchemaConstructable,
Serializable {
    private static final Schema AVRO_SCHEMA = AvroSchemaUtil.convert(ManifestFile.schema(), "manifest_file");
    private static final ManifestContent[] MANIFEST_CONTENT_VALUES = ManifestContent.values();
    private transient Schema avroSchema;
    private int[] fromProjectionPos;
    private InputFile file = null;
    private String manifestPath = null;
    private Long length = null;
    private int specId = -1;
    private ManifestContent content = ManifestContent.DATA;
    private long sequenceNumber = 0L;
    private long minSequenceNumber = 0L;
    private Long snapshotId = null;
    private Integer addedFilesCount = null;
    private Integer existingFilesCount = null;
    private Integer deletedFilesCount = null;
    private Long addedRowsCount = null;
    private Long existingRowsCount = null;
    private Long deletedRowsCount = null;
    private ManifestFile.PartitionFieldSummary[] partitions = null;
    private byte[] keyMetadata = null;

    public GenericManifestFile(Schema avroSchema) {
        this.avroSchema = avroSchema;
        List fields = AvroSchemaUtil.convert(avroSchema).asStructType().fields();
        List allFields = ManifestFile.schema().asStruct().fields();
        this.fromProjectionPos = new int[fields.size()];
        for (int i = 0; i < this.fromProjectionPos.length; ++i) {
            boolean found = false;
            for (int j = 0; j < allFields.size(); ++j) {
                if (((Types.NestedField)fields.get(i)).fieldId() != ((Types.NestedField)allFields.get(j)).fieldId()) continue;
                found = true;
                this.fromProjectionPos[i] = j;
            }
            if (found) continue;
            throw new IllegalArgumentException("Cannot find projected field: " + fields.get(i));
        }
    }

    GenericManifestFile(InputFile file, int specId) {
        this.avroSchema = AVRO_SCHEMA;
        this.file = file;
        this.manifestPath = file.location();
        this.length = null;
        this.specId = specId;
        this.sequenceNumber = 0L;
        this.minSequenceNumber = 0L;
        this.snapshotId = null;
        this.addedFilesCount = null;
        this.addedRowsCount = null;
        this.existingFilesCount = null;
        this.existingRowsCount = null;
        this.deletedFilesCount = null;
        this.deletedRowsCount = null;
        this.partitions = null;
        this.fromProjectionPos = null;
        this.keyMetadata = null;
    }

    public GenericManifestFile(String path, long length, int specId, ManifestContent content, long sequenceNumber, long minSequenceNumber, Long snapshotId, int addedFilesCount, long addedRowsCount, int existingFilesCount, long existingRowsCount, int deletedFilesCount, long deletedRowsCount, List<ManifestFile.PartitionFieldSummary> partitions, ByteBuffer keyMetadata) {
        this.avroSchema = AVRO_SCHEMA;
        this.manifestPath = path;
        this.length = length;
        this.specId = specId;
        this.content = content;
        this.sequenceNumber = sequenceNumber;
        this.minSequenceNumber = minSequenceNumber;
        this.snapshotId = snapshotId;
        this.addedFilesCount = addedFilesCount;
        this.addedRowsCount = addedRowsCount;
        this.existingFilesCount = existingFilesCount;
        this.existingRowsCount = existingRowsCount;
        this.deletedFilesCount = deletedFilesCount;
        this.deletedRowsCount = deletedRowsCount;
        this.partitions = partitions == null ? null : partitions.toArray(new ManifestFile.PartitionFieldSummary[0]);
        this.fromProjectionPos = null;
        this.keyMetadata = ByteBuffers.toByteArray((ByteBuffer)keyMetadata);
    }

    private GenericManifestFile(GenericManifestFile toCopy) {
        this.avroSchema = toCopy.avroSchema;
        this.manifestPath = toCopy.manifestPath;
        this.length = toCopy.length;
        this.specId = toCopy.specId;
        this.content = toCopy.content;
        this.sequenceNumber = toCopy.sequenceNumber;
        this.minSequenceNumber = toCopy.minSequenceNumber;
        this.snapshotId = toCopy.snapshotId;
        this.addedFilesCount = toCopy.addedFilesCount;
        this.addedRowsCount = toCopy.addedRowsCount;
        this.existingFilesCount = toCopy.existingFilesCount;
        this.existingRowsCount = toCopy.existingRowsCount;
        this.deletedFilesCount = toCopy.deletedFilesCount;
        this.deletedRowsCount = toCopy.deletedRowsCount;
        this.partitions = toCopy.partitions != null ? (ManifestFile.PartitionFieldSummary[])Stream.of(toCopy.partitions).map(ManifestFile.PartitionFieldSummary::copy).toArray(ManifestFile.PartitionFieldSummary[]::new) : null;
        this.fromProjectionPos = toCopy.fromProjectionPos;
        this.keyMetadata = toCopy.keyMetadata == null ? null : Arrays.copyOf(toCopy.keyMetadata, toCopy.keyMetadata.length);
    }

    GenericManifestFile() {
    }

    public String path() {
        return this.manifestPath;
    }

    public Long lazyLength() {
        if (this.length == null) {
            if (this.file != null) {
                this.length = this.file.getLength();
            } else {
                return null;
            }
        }
        return this.length;
    }

    public long length() {
        return this.lazyLength();
    }

    public int partitionSpecId() {
        return this.specId;
    }

    public ManifestContent content() {
        return this.content;
    }

    public long sequenceNumber() {
        return this.sequenceNumber;
    }

    public long minSequenceNumber() {
        return this.minSequenceNumber;
    }

    public Long snapshotId() {
        return this.snapshotId;
    }

    public Integer addedFilesCount() {
        return this.addedFilesCount;
    }

    public Long addedRowsCount() {
        return this.addedRowsCount;
    }

    public Integer existingFilesCount() {
        return this.existingFilesCount;
    }

    public Long existingRowsCount() {
        return this.existingRowsCount;
    }

    public Integer deletedFilesCount() {
        return this.deletedFilesCount;
    }

    public Long deletedRowsCount() {
        return this.deletedRowsCount;
    }

    public List<ManifestFile.PartitionFieldSummary> partitions() {
        return this.partitions == null ? null : Arrays.asList(this.partitions);
    }

    public ByteBuffer keyMetadata() {
        return this.keyMetadata == null ? null : ByteBuffer.wrap(this.keyMetadata);
    }

    public int size() {
        return ManifestFile.schema().columns().size();
    }

    public <T> T get(int pos, Class<T> javaClass) {
        return javaClass.cast(this.get(pos));
    }

    public Object get(int i) {
        int pos = i;
        if (this.fromProjectionPos != null) {
            pos = this.fromProjectionPos[i];
        }
        switch (pos) {
            case 0: {
                return this.manifestPath;
            }
            case 1: {
                return this.lazyLength();
            }
            case 2: {
                return this.specId;
            }
            case 3: {
                return this.content.id();
            }
            case 4: {
                return this.sequenceNumber;
            }
            case 5: {
                return this.minSequenceNumber;
            }
            case 6: {
                return this.snapshotId;
            }
            case 7: {
                return this.addedFilesCount;
            }
            case 8: {
                return this.existingFilesCount;
            }
            case 9: {
                return this.deletedFilesCount;
            }
            case 10: {
                return this.addedRowsCount;
            }
            case 11: {
                return this.existingRowsCount;
            }
            case 12: {
                return this.deletedRowsCount;
            }
            case 13: {
                return this.partitions();
            }
            case 14: {
                return this.keyMetadata();
            }
        }
        throw new UnsupportedOperationException("Unknown field ordinal: " + pos);
    }

    public <T> void set(int i, T value) {
        int pos = i;
        if (this.fromProjectionPos != null) {
            pos = this.fromProjectionPos[i];
        }
        switch (pos) {
            case 0: {
                this.manifestPath = value.toString();
                return;
            }
            case 1: {
                this.length = (Long)value;
                return;
            }
            case 2: {
                this.specId = (Integer)value;
                return;
            }
            case 3: {
                this.content = value != null ? MANIFEST_CONTENT_VALUES[(Integer)value] : ManifestContent.DATA;
                return;
            }
            case 4: {
                this.sequenceNumber = value != null ? (Long)value : 0L;
                return;
            }
            case 5: {
                this.minSequenceNumber = value != null ? (Long)value : 0L;
                return;
            }
            case 6: {
                this.snapshotId = (Long)value;
                return;
            }
            case 7: {
                this.addedFilesCount = (Integer)value;
                return;
            }
            case 8: {
                this.existingFilesCount = (Integer)value;
                return;
            }
            case 9: {
                this.deletedFilesCount = (Integer)value;
                return;
            }
            case 10: {
                this.addedRowsCount = (Long)value;
                return;
            }
            case 11: {
                this.existingRowsCount = (Long)value;
                return;
            }
            case 12: {
                this.deletedRowsCount = (Long)value;
                return;
            }
            case 13: {
                this.partitions = value == null ? null : ((List)value).toArray(new ManifestFile.PartitionFieldSummary[0]);
                return;
            }
            case 14: {
                this.keyMetadata = ByteBuffers.toByteArray((ByteBuffer)((ByteBuffer)value));
                return;
            }
        }
    }

    public void put(int i, Object v) {
        this.set(i, v);
    }

    public ManifestFile copy() {
        return new GenericManifestFile(this);
    }

    public Schema getSchema() {
        return this.avroSchema;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GenericManifestFile)) {
            return false;
        }
        GenericManifestFile that = (GenericManifestFile)other;
        return Objects.equal((Object)this.manifestPath, (Object)that.manifestPath);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.manifestPath});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("content", (Object)this.content).add("path", (Object)this.manifestPath).add("length", (Object)this.length).add("partition_spec_id", this.specId).add("added_snapshot_id", (Object)this.snapshotId).add("added_data_files_count", (Object)this.addedFilesCount).add("added_rows_count", (Object)this.addedRowsCount).add("existing_data_files_count", (Object)this.existingFilesCount).add("existing_rows_count", (Object)this.existingRowsCount).add("deleted_data_files_count", (Object)this.deletedFilesCount).add("deleted_rows_count", (Object)this.deletedRowsCount).add("partitions", (Object)this.partitions).add("key_metadata", (Object)(this.keyMetadata == null ? "null" : "(redacted)")).add("sequence_number", this.sequenceNumber).add("min_sequence_number", this.minSequenceNumber).toString();
    }

    public static CopyBuilder copyOf(ManifestFile manifestFile) {
        return new CopyBuilder(manifestFile);
    }

    private static <E, R> List<R> copyList(List<E> list, Function<E, R> transform) {
        if (list != null) {
            ArrayList copy = Lists.newArrayListWithExpectedSize((int)list.size());
            for (E element : list) {
                copy.add(transform.apply(element));
            }
            return copy;
        }
        return null;
    }

    public static class CopyBuilder {
        private final GenericManifestFile manifestFile;

        private CopyBuilder(ManifestFile toCopy) {
            this.manifestFile = toCopy instanceof GenericManifestFile ? new GenericManifestFile((GenericManifestFile)toCopy) : new GenericManifestFile(toCopy.path(), toCopy.length(), toCopy.partitionSpecId(), toCopy.content(), toCopy.sequenceNumber(), toCopy.minSequenceNumber(), toCopy.snapshotId(), toCopy.addedFilesCount(), toCopy.addedRowsCount(), toCopy.existingFilesCount(), toCopy.existingRowsCount(), toCopy.deletedFilesCount(), toCopy.deletedRowsCount(), GenericManifestFile.copyList(toCopy.partitions(), ManifestFile.PartitionFieldSummary::copy), toCopy.keyMetadata());
        }

        public CopyBuilder withSnapshotId(Long newSnapshotId) {
            this.manifestFile.snapshotId = newSnapshotId;
            return this;
        }

        public ManifestFile build() {
            return this.manifestFile;
        }
    }
}

