/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client.spooling.encoding;

import io.trino.jdbc.$internal.airlift.compress.lz4.Lz4Decompressor;
import io.trino.jdbc.$internal.client.QueryDataDecoder;
import io.trino.jdbc.$internal.client.spooling.encoding.CompressedQueryDataDecoder;
import io.trino.jdbc.$internal.guava.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Lz4QueryDataDecoder
extends CompressedQueryDataDecoder {
    public Lz4QueryDataDecoder(QueryDataDecoder delegate) {
        super(delegate);
    }

    @Override
    InputStream decompress(InputStream stream, int uncompressedSize) throws IOException {
        byte[] output;
        Lz4Decompressor decompressor = new Lz4Decompressor();
        byte[] bytes = ByteStreams.toByteArray(stream);
        int decompressedSize = decompressor.decompress(bytes, 0, bytes.length, output = new byte[uncompressedSize], 0, output.length);
        if (decompressedSize != uncompressedSize) {
            throw new IOException(String.format("Decompressed size does not match expected segment size, expected %d, got %d", decompressedSize, uncompressedSize));
        }
        return new ByteArrayInputStream(output);
    }

    @Override
    public String encoding() {
        return this.delegate.encoding() + "+lz4";
    }
}

