/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v1_11;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.handlers.RequestHandler2;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.contrib.awsxray.propagator.AwsXrayPropagator;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.internal.InstrumenterUtil;
import io.opentelemetry.instrumentation.api.internal.Timer;
import io.opentelemetry.instrumentation.awssdk.v1_11.HeaderSetter;
import io.opentelemetry.instrumentation.awssdk.v1_11.SqsAccess;
import io.opentelemetry.instrumentation.awssdk.v1_11.SqsProcessRequest;
import io.opentelemetry.instrumentation.awssdk.v1_11.SqsReceiveRequest;
import java.time.Instant;
import javax.annotation.Nullable;

final class TracingRequestHandler
extends RequestHandler2 {
    static final HandlerContextKey<Context> CONTEXT = new HandlerContextKey(Context.class.getName());
    private static final ContextKey<Context> PARENT_CONTEXT_KEY = ContextKey.named((String)(TracingRequestHandler.class.getName() + ".ParentContext"));
    private static final ContextKey<Timer> REQUEST_TIMER_KEY = ContextKey.named((String)(TracingRequestHandler.class.getName() + ".Timer"));
    private static final ContextKey<Boolean> REQUEST_SPAN_SUPPRESSED_KEY = ContextKey.named((String)(TracingRequestHandler.class.getName() + ".RequestSpanSuppressed"));
    private final Instrumenter<Request<?>, Response<?>> requestInstrumenter;
    private final Instrumenter<SqsReceiveRequest, Response<?>> consumerReceiveInstrumenter;
    private final Instrumenter<SqsProcessRequest, Response<?>> consumerProcessInstrumenter;
    private final Instrumenter<Request<?>, Response<?>> producerInstrumenter;

    TracingRequestHandler(Instrumenter<Request<?>, Response<?>> requestInstrumenter, Instrumenter<SqsReceiveRequest, Response<?>> consumerReceiveInstrumenter, Instrumenter<SqsProcessRequest, Response<?>> consumerProcessInstrumenter, Instrumenter<Request<?>, Response<?>> producerInstrumenter) {
        this.requestInstrumenter = requestInstrumenter;
        this.consumerReceiveInstrumenter = consumerReceiveInstrumenter;
        this.consumerProcessInstrumenter = consumerProcessInstrumenter;
        this.producerInstrumenter = producerInstrumenter;
    }

    public void beforeRequest(Request<?> request) {
        Context parentContext;
        if ("com.amazonaws.services.s3.model.GeneratePresignedUrlRequest".equals(request.getOriginalRequest().getClass().getName())) {
            return;
        }
        Instrumenter<Request<?>, Response<?>> instrumenter = this.getInstrumenter(request);
        if (!instrumenter.shouldStart(parentContext = Context.current(), request)) {
            return;
        }
        if (Span.fromContextOrNull((Context)parentContext) == null && "com.amazonaws.services.sqs.model.ReceiveMessageRequest".equals(request.getOriginalRequest().getClass().getName())) {
            Context context = InstrumenterUtil.suppressSpan(instrumenter, (Context)parentContext, request);
            context = context.with(REQUEST_TIMER_KEY, (Object)Timer.start());
            context = context.with(PARENT_CONTEXT_KEY, (Object)parentContext);
            context = context.with(REQUEST_SPAN_SUPPRESSED_KEY, (Object)Boolean.TRUE);
            request.addHandlerContext(CONTEXT, (Object)context);
            return;
        }
        Context context = instrumenter.start(parentContext, request);
        context = context.with(REQUEST_TIMER_KEY, (Object)Timer.start());
        context = context.with(PARENT_CONTEXT_KEY, (Object)parentContext);
        AwsXrayPropagator.getInstance().inject(context, request, (TextMapSetter)HeaderSetter.INSTANCE);
        request.addHandlerContext(CONTEXT, (Object)context);
    }

    @CanIgnoreReturnValue
    public AmazonWebServiceRequest beforeMarshalling(AmazonWebServiceRequest request) {
        SqsAccess.beforeMarshalling(request);
        return request;
    }

    Instrumenter<SqsReceiveRequest, Response<?>> getConsumerReceiveInstrumenter() {
        return this.consumerReceiveInstrumenter;
    }

    Instrumenter<SqsProcessRequest, Response<?>> getConsumerProcessInstrumenter() {
        return this.consumerProcessInstrumenter;
    }

    public void afterResponse(Request<?> request, Response<?> response) {
        Context context = (Context)request.getHandlerContext(CONTEXT);
        if (context == null) {
            return;
        }
        Timer timer = (Timer)context.get(REQUEST_TIMER_KEY);
        Context parentContext = (Context)context.get(PARENT_CONTEXT_KEY);
        SqsAccess.afterResponse(request, response, timer, parentContext, this);
        this.finish(request, response, null);
    }

    public void afterError(Request<?> request, Response<?> response, Exception e) {
        this.finish(request, response, e);
    }

    private void finish(Request<?> request, Response<?> response, @Nullable Throwable error) {
        Context context = (Context)request.getHandlerContext(CONTEXT);
        if (context == null) {
            return;
        }
        request.addHandlerContext(CONTEXT, null);
        Instrumenter<Request<?>, Response<?>> instrumenter = this.getInstrumenter(request);
        if (Boolean.TRUE.equals(context.get(REQUEST_SPAN_SUPPRESSED_KEY))) {
            Context parentContext = (Context)context.get(PARENT_CONTEXT_KEY);
            Timer timer = (Timer)context.get(REQUEST_TIMER_KEY);
            if (error != null && parentContext != null && timer != null && this.requestInstrumenter.shouldStart(parentContext, request)) {
                InstrumenterUtil.startAndEnd(instrumenter, (Context)parentContext, request, response, (Throwable)error, (Instant)timer.startTime(), (Instant)timer.now());
            }
            return;
        }
        instrumenter.end(context, request, response, error);
    }

    private Instrumenter<Request<?>, Response<?>> getInstrumenter(Request<?> request) {
        boolean isSqsProducer = "com.amazonaws.services.sqs.model.SendMessageRequest".equals(request.getOriginalRequest().getClass().getName());
        return isSqsProducer ? this.producerInstrumenter : this.requestInstrumenter;
    }
}

