/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.LongSummaryStatistics;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.DirEntry;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.EntryStatus;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.FileEntry;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.TaskManifest;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.ManifestCommitterSupport;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.AbstractJobOrTaskStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.StageConfig;
import org.apache.hadoop.util.DurationInfo;

public final class TaskAttemptScanDirectoryStage
extends AbstractJobOrTaskStage<Void, TaskManifest> {
    private static final Logger LOG = LoggerFactory.getLogger(TaskAttemptScanDirectoryStage.class);

    public TaskAttemptScanDirectoryStage(StageConfig stageConfig) {
        super(true, stageConfig, "task_stage_scan_directory", false);
    }

    @Override
    protected TaskManifest executeStage(Void arguments) throws IOException {
        Path taskAttemptDir = this.getRequiredTaskAttemptDir();
        TaskManifest manifest = ManifestCommitterSupport.createTaskManifest(this.getStageConfig());
        LOG.info("{}: scanning directory {}", (Object)this.getName(), (Object)taskAttemptDir);
        int depth = this.scanDirectoryTree(manifest, taskAttemptDir, this.getDestinationDir(), 0, true);
        List<FileEntry> filesToCommit = manifest.getFilesToCommit();
        LongSummaryStatistics fileSummary = filesToCommit.stream().mapToLong(FileEntry::getSize).summaryStatistics();
        long fileDataSize = fileSummary.getSum();
        long fileCount = fileSummary.getCount();
        int dirCount = manifest.getDestDirectories().size();
        LOG.info("{}: directory {} contained {} file(s); data size {}", this.getName(), taskAttemptDir, fileCount, fileDataSize);
        LOG.info("{}: Directory count = {}; maximum depth {}", this.getName(), dirCount, depth);
        IOStatisticsStore iostats = this.getIOStatistics();
        iostats.addSample("committer_task_directory_count", dirCount);
        iostats.addSample("committer_task_directory_depth", depth);
        iostats.addSample("committer_task_file_count", fileCount);
        iostats.addSample("committer_task_file_size", fileDataSize);
        return manifest;
    }

    private int scanDirectoryTree(TaskManifest manifest, Path srcDir, Path destDir, int depth, boolean parentDirExists) throws IOException {
        this.progress();
        int maxDepth = 0;
        int files = 0;
        boolean dirExists = parentDirExists;
        ArrayList<FileStatus> subdirs = new ArrayList<FileStatus>();
        try (DurationInfo ignored = new DurationInfo(LOG, false, "Task Attempt %s source dir %s, dest dir %s", this.getTaskAttemptId(), srcDir, destDir);){
            RemoteIterator<FileStatus> listing = this.listStatusIterator(srcDir);
            if (depth > 0) {
                EntryStatus status;
                if (parentDirExists) {
                    FileStatus destDirStatus = this.getFileStatusOrNull(destDir);
                    status = EntryStatus.toEntryStatus(destDirStatus);
                    dirExists = destDirStatus != null;
                } else {
                    status = EntryStatus.not_found;
                }
                manifest.addDirectory(DirEntry.dirEntry(destDir, status, depth));
            }
            while (listing.hasNext()) {
                FileStatus st = listing.next();
                if (st.isFile()) {
                    ++files;
                    FileEntry entry = this.fileEntry(st, destDir);
                    manifest.addFileToCommit(entry);
                    LOG.debug("To rename: {}", (Object)entry);
                    continue;
                }
                if (st.isDirectory()) {
                    subdirs.add(st);
                    continue;
                }
                LOG.info("Ignoring FS object {}", (Object)st);
            }
            ManifestCommitterSupport.maybeAddIOStatistics(this.getIOStatistics(), listing);
        }
        LOG.debug("{}: Number of subdirectories under {} found: {}; file count {}", this.getName(), srcDir, subdirs.size(), files);
        for (FileStatus st : subdirs) {
            Path destSubDir = new Path(destDir, st.getPath().getName());
            int d = this.scanDirectoryTree(manifest, st.getPath(), destSubDir, depth + 1, dirExists);
            maxDepth = Math.max(maxDepth, d);
        }
        return 1 + maxDepth;
    }
}

