/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.shortcircuit;

import io.trino.hadoop.$internal.org.apache.commons.collections.map.LinkedMap;
import io.trino.hadoop.$internal.org.apache.commons.lang3.mutable.MutableBoolean;
import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.SocketException;
import java.nio.MappedByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.ExtendedBlockId;
import org.apache.hadoop.hdfs.client.impl.DfsClientConf;
import org.apache.hadoop.hdfs.net.DomainPeer;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.datatransfer.Sender;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.shortcircuit.ClientMmap;
import org.apache.hadoop.hdfs.shortcircuit.DfsClientShm;
import org.apache.hadoop.hdfs.shortcircuit.DfsClientShmManager;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitReplica;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitReplicaInfo;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitShm;
import org.apache.hadoop.hdfs.util.IOUtilsClient;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.net.unix.DomainSocketWatcher;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.Waitable;

@InterfaceAudience.Private
public class ShortCircuitCache
implements Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(ShortCircuitCache.class);
    private final ReentrantLock lock = new ReentrantLock();
    private final ScheduledThreadPoolExecutor cleanerExecutor = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ShortCircuitCache_Cleaner").build());
    private final ScheduledThreadPoolExecutor releaserExecutor = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ShortCircuitCache_SlotReleaser").build());
    private final HashMap<ExtendedBlockId, Waitable<ShortCircuitReplicaInfo>> replicaInfoMap = new HashMap();
    private CacheCleaner cacheCleaner;
    private final LinkedMap evictable = new LinkedMap();
    private int maxTotalSize;
    private long maxNonMmappedEvictableLifespanMs;
    private final LinkedMap evictableMmapped = new LinkedMap();
    private int maxEvictableMmapedSize;
    private final long maxEvictableMmapedLifespanMs;
    private final long mmapRetryTimeoutMs;
    private final long staleThresholdMs;
    private boolean closed = false;
    private int outstandingMmapCount = 0;
    private final DfsClientShmManager shmManager;
    private Map<String, DomainSocket> pathToDomainSocket = new HashMap<String, DomainSocket>();
    static final int FETCH_OR_CREATE_RETRY_TIMES = 3;

    public static ShortCircuitCache fromConf(DfsClientConf.ShortCircuitConf conf) {
        return new ShortCircuitCache(conf.getShortCircuitStreamsCacheSize(), conf.getShortCircuitStreamsCacheExpiryMs(), conf.getShortCircuitMmapCacheSize(), conf.getShortCircuitMmapCacheExpiryMs(), conf.getShortCircuitMmapCacheRetryTimeout(), conf.getShortCircuitCacheStaleThresholdMs(), conf.getShortCircuitSharedMemoryWatcherInterruptCheckMs());
    }

    public ShortCircuitCache(int maxTotalSize, long maxNonMmappedEvictableLifespanMs, int maxEvictableMmapedSize, long maxEvictableMmapedLifespanMs, long mmapRetryTimeoutMs, long staleThresholdMs, int shmInterruptCheckMs) {
        Preconditions.checkArgument(maxTotalSize >= 0);
        this.maxTotalSize = maxTotalSize;
        Preconditions.checkArgument(maxNonMmappedEvictableLifespanMs >= 0L);
        this.maxNonMmappedEvictableLifespanMs = maxNonMmappedEvictableLifespanMs;
        Preconditions.checkArgument(maxEvictableMmapedSize >= 0);
        this.maxEvictableMmapedSize = maxEvictableMmapedSize;
        Preconditions.checkArgument(maxEvictableMmapedLifespanMs >= 0L);
        this.maxEvictableMmapedLifespanMs = maxEvictableMmapedLifespanMs;
        this.mmapRetryTimeoutMs = mmapRetryTimeoutMs;
        this.staleThresholdMs = staleThresholdMs;
        DfsClientShmManager shmManager = null;
        if (shmInterruptCheckMs > 0 && DomainSocketWatcher.getLoadingFailureReason() == null) {
            try {
                shmManager = new DfsClientShmManager(shmInterruptCheckMs);
            }
            catch (IOException e) {
                LOG.error("failed to create ShortCircuitShmManager", e);
            }
        }
        this.shmManager = shmManager;
    }

    public long getStaleThresholdMs() {
        return this.staleThresholdMs;
    }

    @VisibleForTesting
    public void setMaxTotalSize(int maxTotalSize) {
        this.maxTotalSize = maxTotalSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ref(ShortCircuitReplica replica) {
        this.lock.lock();
        try {
            Preconditions.checkArgument(replica.refCount > 0, "can't ref %s because its refCount reached %d", (Object)replica, replica.refCount);
            Long evictableTimeNs = replica.getEvictableTimeNs();
            ++replica.refCount;
            if (evictableTimeNs != null) {
                String removedFrom = this.removeEvictable(replica);
                if (LOG.isTraceEnabled()) {
                    LOG.trace(this + ": " + removedFrom + " no longer contains " + replica + ".  refCount " + (replica.refCount - 1) + " -> " + replica.refCount + StringUtils.getStackTrace(Thread.currentThread()));
                }
            } else if (LOG.isTraceEnabled()) {
                LOG.trace(this + ": replica  refCount " + (replica.refCount - 1) + " -> " + replica.refCount + StringUtils.getStackTrace(Thread.currentThread()));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unref(ShortCircuitReplica replica) {
        this.lock.lock();
        try {
            int newRefCount;
            if (!replica.purged) {
                String purgeReason = null;
                if (!replica.getDataStream().getChannel().isOpen()) {
                    purgeReason = "purging replica because its data channel is closed.";
                } else if (!replica.getMetaStream().getChannel().isOpen()) {
                    purgeReason = "purging replica because its meta channel is closed.";
                } else if (replica.isStale()) {
                    purgeReason = "purging replica because it is stale.";
                }
                if (purgeReason != null) {
                    LOG.debug("{}: {}", (Object)this, (Object)purgeReason);
                    this.purge(replica);
                }
            }
            String addedString = "";
            boolean shouldTrimEvictionMaps = false;
            if ((newRefCount = --replica.refCount) == 0) {
                Preconditions.checkArgument(replica.purged, "Replica %s reached a refCount of 0 without being purged", (Object)replica);
                replica.close();
            } else if (newRefCount == 1) {
                Preconditions.checkState(null == replica.getEvictableTimeNs(), "Replica %s had a refCount higher than 1, but was still evictable (evictableTimeNs = %d)", (Object)replica, (Object)replica.getEvictableTimeNs());
                if (!replica.purged) {
                    if (replica.hasMmap()) {
                        this.insertEvictable(System.nanoTime(), replica, this.evictableMmapped);
                        addedString = "added to evictableMmapped, ";
                    } else {
                        this.insertEvictable(System.nanoTime(), replica, this.evictable);
                        addedString = "added to evictable, ";
                    }
                    shouldTrimEvictionMaps = true;
                }
            } else {
                Preconditions.checkArgument(replica.refCount >= 0, "replica's refCount went negative (refCount = %d for %s)", replica.refCount, (Object)replica);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace(this + ": unref replica " + replica + ": " + addedString + " refCount " + (newRefCount + 1) + " -> " + newRefCount + StringUtils.getStackTrace(Thread.currentThread()));
            }
            if (shouldTrimEvictionMaps) {
                this.trimEvictionMaps();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private int demoteOldEvictableMmaped(long now) {
        int numDemoted = 0;
        boolean needMoreSpace = false;
        while (!this.evictableMmapped.isEmpty()) {
            Object eldestKey = this.evictableMmapped.firstKey();
            Long evictionTimeNs = (Long)eldestKey;
            long evictionTimeMs = TimeUnit.MILLISECONDS.convert(evictionTimeNs, TimeUnit.NANOSECONDS);
            if (evictionTimeMs + this.maxEvictableMmapedLifespanMs >= now) {
                if (this.evictableMmapped.size() < this.maxEvictableMmapedSize) break;
                needMoreSpace = true;
            }
            ShortCircuitReplica replica = (ShortCircuitReplica)this.evictableMmapped.get(eldestKey);
            if (LOG.isTraceEnabled()) {
                String rationale = needMoreSpace ? "because we need more space" : "because it's too old";
                LOG.trace("demoteOldEvictable: demoting " + replica + ": " + rationale + ": " + StringUtils.getStackTrace(Thread.currentThread()));
            }
            this.removeEvictable(replica, this.evictableMmapped);
            this.munmap(replica);
            this.insertEvictable(evictionTimeNs, replica, this.evictable);
            ++numDemoted;
        }
        return numDemoted;
    }

    private void trimEvictionMaps() {
        long now = Time.monotonicNow();
        this.demoteOldEvictableMmaped(now);
        while (this.evictable.size() + this.evictableMmapped.size() > this.maxTotalSize) {
            ShortCircuitReplica replica = this.evictable.isEmpty() ? (ShortCircuitReplica)this.evictableMmapped.get(this.evictableMmapped.firstKey()) : (ShortCircuitReplica)this.evictable.get(this.evictable.firstKey());
            if (LOG.isTraceEnabled()) {
                LOG.trace(this + ": trimEvictionMaps is purging " + replica + StringUtils.getStackTrace(Thread.currentThread()));
            }
            this.purge(replica);
        }
    }

    private void munmap(ShortCircuitReplica replica) {
        replica.munmap();
        --this.outstandingMmapCount;
    }

    private String removeEvictable(ShortCircuitReplica replica) {
        if (replica.hasMmap()) {
            this.removeEvictable(replica, this.evictableMmapped);
            return "evictableMmapped";
        }
        this.removeEvictable(replica, this.evictable);
        return "evictable";
    }

    private void removeEvictable(ShortCircuitReplica replica, LinkedMap map) {
        Long evictableTimeNs = replica.getEvictableTimeNs();
        Preconditions.checkNotNull(evictableTimeNs);
        ShortCircuitReplica removed = (ShortCircuitReplica)map.remove(evictableTimeNs);
        Preconditions.checkState(removed == replica, "failed to make %s unevictable", (Object)replica);
        replica.setEvictableTimeNs(null);
    }

    private void insertEvictable(Long evictionTimeNs, ShortCircuitReplica replica, LinkedMap map) {
        while (map.containsKey(evictionTimeNs)) {
            Long l = evictionTimeNs;
            Long l2 = evictionTimeNs = Long.valueOf(evictionTimeNs + 1L);
        }
        Preconditions.checkState(null == replica.getEvictableTimeNs());
        replica.setEvictableTimeNs(evictionTimeNs);
        map.put(evictionTimeNs, replica);
    }

    private void purge(ShortCircuitReplica replica) {
        Long evictableTimeNs;
        ShortCircuitReplicaInfo info;
        boolean removedFromInfoMap = false;
        String evictionMapName = null;
        Preconditions.checkArgument(!replica.purged);
        replica.purged = true;
        Waitable<ShortCircuitReplicaInfo> val = this.replicaInfoMap.get(replica.key);
        if (val != null && (info = val.getVal()) != null && info.getReplica() == replica) {
            this.replicaInfoMap.remove(replica.key);
            removedFromInfoMap = true;
        }
        if ((evictableTimeNs = replica.getEvictableTimeNs()) != null) {
            evictionMapName = this.removeEvictable(replica);
        }
        if (LOG.isTraceEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append(this).append(": ").append(": purged ").append(replica).append(" from the cache.");
            if (removedFromInfoMap) {
                builder.append("  Removed from the replicaInfoMap.");
            }
            if (evictionMapName != null) {
                builder.append("  Removed from ").append(evictionMapName);
            }
            LOG.trace(builder.toString());
        }
        this.unref(replica);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShortCircuitReplicaInfo fetchOrCreate(ExtendedBlockId key, ShortCircuitReplicaCreator creator) {
        Waitable<ShortCircuitReplicaInfo> newWaitable;
        this.lock.lock();
        try {
            ShortCircuitReplicaInfo info = null;
            for (int i = 0; i < 3; ++i) {
                if (this.closed) {
                    LOG.trace("{}: can't fethchOrCreate {} because the cache is closed.", (Object)this, (Object)key);
                    ShortCircuitReplicaInfo shortCircuitReplicaInfo = null;
                    return shortCircuitReplicaInfo;
                }
                Waitable<ShortCircuitReplicaInfo> waitable = this.replicaInfoMap.get(key);
                if (waitable == null) continue;
                try {
                    info = this.fetch(key, waitable);
                    break;
                }
                catch (RetriableException e) {
                    LOG.debug("{}: retrying {}", (Object)this, (Object)e.getMessage());
                }
            }
            if (info != null) {
                ShortCircuitReplicaInfo shortCircuitReplicaInfo = info;
                return shortCircuitReplicaInfo;
            }
            newWaitable = new Waitable<ShortCircuitReplicaInfo>(this.lock.newCondition());
            this.replicaInfoMap.put(key, newWaitable);
        }
        finally {
            this.lock.unlock();
        }
        return this.create(key, creator, newWaitable);
    }

    @VisibleForTesting
    protected ShortCircuitReplicaInfo fetch(ExtendedBlockId key, Waitable<ShortCircuitReplicaInfo> waitable) throws RetriableException {
        ShortCircuitReplicaInfo info;
        try {
            LOG.trace("{}: found waitable for {}", (Object)this, (Object)key);
            info = waitable.await();
        }
        catch (InterruptedException e) {
            LOG.info(this + ": interrupted while waiting for " + key);
            Thread.currentThread().interrupt();
            throw new RetriableException("interrupted");
        }
        if (info.getInvalidTokenException() != null) {
            LOG.info(this + ": could not get " + key + " due to InvalidToken exception.", info.getInvalidTokenException());
            return info;
        }
        ShortCircuitReplica replica = info.getReplica();
        if (replica == null) {
            LOG.warn(this + ": failed to get " + key);
            return info;
        }
        if (replica.purged) {
            throw new RetriableException("Ignoring purged replica " + replica + ".  Retrying.");
        }
        if (replica.isStale()) {
            LOG.info(this + ": got stale replica " + replica + ".  Removing this replica from the replicaInfoMap and retrying.");
            this.purge(replica);
            throw new RetriableException("ignoring stale replica " + replica);
        }
        this.ref(replica);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShortCircuitReplicaInfo create(ExtendedBlockId key, ShortCircuitReplicaCreator creator, Waitable<ShortCircuitReplicaInfo> newWaitable) {
        ShortCircuitReplicaInfo info = null;
        try {
            LOG.trace("{}: loading {}", (Object)this, (Object)key);
            info = creator.createShortCircuitReplicaInfo();
        }
        catch (RuntimeException e) {
            LOG.warn(this + ": failed to load " + key, e);
        }
        if (info == null) {
            info = new ShortCircuitReplicaInfo();
        }
        this.lock.lock();
        try {
            if (info.getReplica() != null) {
                LOG.trace("{}: successfully loaded {}", (Object)this, (Object)info.getReplica());
                this.startCacheCleanerThreadIfNeeded();
            } else {
                Waitable<ShortCircuitReplicaInfo> waitableInMap = this.replicaInfoMap.get(key);
                if (waitableInMap == newWaitable) {
                    this.replicaInfoMap.remove(key);
                }
                if (info.getInvalidTokenException() != null) {
                    LOG.info(this + ": could not load " + key + " due to InvalidToken exception.", info.getInvalidTokenException());
                } else {
                    LOG.warn(this + ": failed to load " + key);
                }
            }
            newWaitable.provide(info);
        }
        finally {
            this.lock.unlock();
        }
        return info;
    }

    private void startCacheCleanerThreadIfNeeded() {
        if (this.cacheCleaner == null) {
            this.cacheCleaner = new CacheCleaner();
            long rateMs = this.cacheCleaner.getRateInMs();
            ScheduledFuture<?> future = this.cleanerExecutor.scheduleAtFixedRate(this.cacheCleaner, rateMs, rateMs, TimeUnit.MILLISECONDS);
            this.cacheCleaner.setFuture(future);
            LOG.debug("{}: starting cache cleaner thread which will run every {} ms", (Object)this, (Object)rateMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientMmap getOrCreateClientMmap(ShortCircuitReplica replica, boolean anchored) {
        Condition newCond;
        this.lock.lock();
        try {
            while (replica.mmapData != null) {
                if (replica.mmapData instanceof MappedByteBuffer) {
                    this.ref(replica);
                    MappedByteBuffer mmap = (MappedByteBuffer)replica.mmapData;
                    ClientMmap clientMmap = new ClientMmap(replica, mmap, anchored);
                    return clientMmap;
                }
                if (replica.mmapData instanceof Long) {
                    long lastAttemptTimeMs = (Long)replica.mmapData;
                    long delta = Time.monotonicNow() - lastAttemptTimeMs;
                    if (delta < this.mmapRetryTimeoutMs) {
                        LOG.trace("{}: can't create client mmap for {} because we failed to create one just {}ms ago.", this, replica, delta);
                        ClientMmap clientMmap = null;
                        return clientMmap;
                    }
                    LOG.trace("{}: retrying client mmap for {}, {} ms after the previous failure.", this, replica, delta);
                    continue;
                }
                if (replica.mmapData instanceof Condition) {
                    Condition cond = (Condition)replica.mmapData;
                    cond.awaitUninterruptibly();
                    continue;
                }
                Preconditions.checkState(false, "invalid mmapData type %s", (Object)replica.mmapData.getClass().getName());
            }
            newCond = this.lock.newCondition();
            replica.mmapData = newCond;
        }
        finally {
            this.lock.unlock();
        }
        MappedByteBuffer map = replica.loadMmapInternal();
        this.lock.lock();
        try {
            if (map == null) {
                replica.mmapData = Time.monotonicNow();
                newCond.signalAll();
                ClientMmap clientMmap = null;
                return clientMmap;
            }
            ++this.outstandingMmapCount;
            replica.mmapData = map;
            this.ref(replica);
            newCond.signalAll();
            ClientMmap clientMmap = new ClientMmap(replica, map, anchored);
            return clientMmap;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        try {
            Object eldestKey;
            this.lock.lock();
            if (this.closed) {
                return;
            }
            this.closed = true;
            LOG.info(this + ": closing");
            this.maxNonMmappedEvictableLifespanMs = 0L;
            this.maxEvictableMmapedSize = 0;
            IOUtilsClient.cleanupWithLogger(LOG, this.cacheCleaner);
            while (!this.evictable.isEmpty()) {
                eldestKey = this.evictable.firstKey();
                this.purge((ShortCircuitReplica)this.evictable.get(eldestKey));
            }
            while (!this.evictableMmapped.isEmpty()) {
                eldestKey = this.evictableMmapped.firstKey();
                this.purge((ShortCircuitReplica)this.evictableMmapped.get(eldestKey));
            }
        }
        finally {
            this.lock.unlock();
        }
        this.releaserExecutor.shutdown();
        this.cleanerExecutor.shutdown();
        try {
            if (!this.releaserExecutor.awaitTermination(30L, TimeUnit.SECONDS)) {
                LOG.error("Forcing SlotReleaserThreadPool to shutdown!");
                this.releaserExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.releaserExecutor.shutdownNow();
            Thread.currentThread().interrupt();
            LOG.error("Interrupted while waiting for SlotReleaserThreadPool to terminate", e);
        }
        try {
            if (!this.cleanerExecutor.awaitTermination(30L, TimeUnit.SECONDS)) {
                LOG.error("Forcing CleanerThreadPool to shutdown!");
                this.cleanerExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.cleanerExecutor.shutdownNow();
            Thread.currentThread().interrupt();
            LOG.error("Interrupted while waiting for CleanerThreadPool to terminate", e);
        }
        IOUtilsClient.cleanupWithLogger(LOG, this.shmManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void accept(CacheVisitor visitor) {
        this.lock.lock();
        try {
            HashMap<ExtendedBlockId, ShortCircuitReplica> replicas = new HashMap<ExtendedBlockId, ShortCircuitReplica>();
            HashMap<ExtendedBlockId, SecretManager.InvalidToken> failedLoads = new HashMap<ExtendedBlockId, SecretManager.InvalidToken>();
            for (Map.Entry<ExtendedBlockId, Waitable<ShortCircuitReplicaInfo>> entry : this.replicaInfoMap.entrySet()) {
                Waitable<ShortCircuitReplicaInfo> waitable = entry.getValue();
                if (!waitable.hasVal()) continue;
                if (waitable.getVal().getReplica() != null) {
                    replicas.put(entry.getKey(), waitable.getVal().getReplica());
                    continue;
                }
                failedLoads.put(entry.getKey(), waitable.getVal().getInvalidTokenException());
            }
            LOG.debug("visiting {} with outstandingMmapCount={}, replicas={}, failedLoads={}, evictable={}, evictableMmapped={}", visitor.getClass().getName(), this.outstandingMmapCount, replicas, failedLoads, this.evictable, this.evictableMmapped);
            visitor.visit(this.outstandingMmapCount, replicas, failedLoads, this.evictable, this.evictableMmapped);
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return "ShortCircuitCache(0x" + Integer.toHexString(System.identityHashCode(this)) + ")";
    }

    public ShortCircuitShm.Slot allocShmSlot(DatanodeInfo datanode, DomainPeer peer, MutableBoolean usedPeer, ExtendedBlockId blockId, String clientName) throws IOException {
        if (this.shmManager != null) {
            return this.shmManager.allocSlot(datanode, peer, usedPeer, blockId, clientName);
        }
        return null;
    }

    public void freeSlot(ShortCircuitShm.Slot slot) {
        Preconditions.checkState(this.shmManager != null);
        slot.makeInvalid();
        this.shmManager.freeSlot(slot);
    }

    public void scheduleSlotReleaser(ShortCircuitShm.Slot slot) {
        if (slot == null) {
            return;
        }
        Preconditions.checkState(this.shmManager != null);
        this.releaserExecutor.execute(new SlotReleaser(slot));
    }

    @VisibleForTesting
    public DfsClientShmManager getDfsClientShmManager() {
        return this.shmManager;
    }

    @VisibleForTesting
    public int getReplicaInfoMapSize() {
        return this.replicaInfoMap.size();
    }

    @VisibleForTesting
    public static interface CacheVisitor {
        public void visit(int var1, Map<ExtendedBlockId, ShortCircuitReplica> var2, Map<ExtendedBlockId, SecretManager.InvalidToken> var3, LinkedMap var4, LinkedMap var5);
    }

    public static interface ShortCircuitReplicaCreator {
        public ShortCircuitReplicaInfo createShortCircuitReplicaInfo();
    }

    private class SlotReleaser
    implements Runnable {
        private final ShortCircuitShm.Slot slot;

        SlotReleaser(ShortCircuitShm.Slot slot) {
            this.slot = slot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block15: {
                if (this.slot == null) {
                    return;
                }
                LOG.trace("{}: about to release {}", (Object)ShortCircuitCache.this, (Object)this.slot);
                DfsClientShm shm = (DfsClientShm)this.slot.getShm();
                DomainSocket shmSock = shm.getPeer().getDomainSocket();
                String path = shmSock.getPath();
                DomainSocket domainSocket = (DomainSocket)ShortCircuitCache.this.pathToDomainSocket.get(path);
                DataOutputStream out = null;
                boolean success = false;
                int retries = 2;
                try {
                    while (retries > 0) {
                        try {
                            if (domainSocket == null || !domainSocket.isOpen()) {
                                domainSocket = DomainSocket.connect(path);
                                ShortCircuitCache.this.pathToDomainSocket.put(path, domainSocket);
                            }
                            out = new DataOutputStream(new BufferedOutputStream(domainSocket.getOutputStream()));
                            new Sender(out).releaseShortCircuitFds(this.slot.getSlotId());
                            DataInputStream in = new DataInputStream(domainSocket.getInputStream());
                            DataTransferProtos.ReleaseShortCircuitAccessResponseProto resp = DataTransferProtos.ReleaseShortCircuitAccessResponseProto.parseFrom(PBHelperClient.vintPrefixed(in));
                            if (resp.getStatus() != DataTransferProtos.Status.SUCCESS) {
                                String error = resp.hasError() ? resp.getError() : "(unknown)";
                                throw new IOException(resp.getStatus().toString() + ": " + error);
                            }
                            LOG.trace("{}: released {}", (Object)this, (Object)this.slot);
                            success = true;
                            break;
                        }
                        catch (SocketException se) {
                            --retries;
                            if (domainSocket != null) {
                                domainSocket.close();
                                domainSocket = null;
                                ShortCircuitCache.this.pathToDomainSocket.remove(path);
                            }
                            if (retries != 0) continue;
                            throw new SocketException("Create domain socket failed");
                        }
                    }
                    if (success) {
                        ShortCircuitCache.this.shmManager.freeSlot(this.slot);
                        break block15;
                    }
                    shm.getEndpointShmManager().shutdown(shm);
                }
                catch (IOException e) {
                    try {
                        LOG.warn(ShortCircuitCache.this + ": failed to release short-circuit shared memory slot " + this.slot + " by sending ReleaseShortCircuitAccessRequestProto to " + path + ".  Closing shared memory segment. DataNode may have been stopped or restarted", e);
                        if (success) {
                            ShortCircuitCache.this.shmManager.freeSlot(this.slot);
                        }
                        shm.getEndpointShmManager().shutdown(shm);
                    }
                    catch (Throwable throwable) {
                        if (success) {
                            ShortCircuitCache.this.shmManager.freeSlot(this.slot);
                        } else {
                            shm.getEndpointShmManager().shutdown(shm);
                            IOUtilsClient.cleanupWithLogger(LOG, domainSocket, out);
                            ShortCircuitCache.this.pathToDomainSocket.remove(path);
                        }
                        throw throwable;
                    }
                    IOUtilsClient.cleanupWithLogger(LOG, domainSocket, out);
                    ShortCircuitCache.this.pathToDomainSocket.remove(path);
                }
                IOUtilsClient.cleanupWithLogger(LOG, domainSocket, out);
                ShortCircuitCache.this.pathToDomainSocket.remove(path);
            }
        }
    }

    private class CacheCleaner
    implements Runnable,
    Closeable {
        private ScheduledFuture<?> future;

        private CacheCleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ShortCircuitCache.this.lock.lock();
            try {
                Object eldestKey;
                Long evictionTimeNs;
                long evictionTimeMs;
                if (ShortCircuitCache.this.closed) {
                    return;
                }
                long curMs = Time.monotonicNow();
                LOG.debug("{}: cache cleaner running at {}", (Object)this, (Object)curMs);
                int numDemoted = ShortCircuitCache.this.demoteOldEvictableMmaped(curMs);
                int numPurged = 0;
                while (!ShortCircuitCache.this.evictable.isEmpty() && (evictionTimeMs = TimeUnit.MILLISECONDS.convert(evictionTimeNs = (Long)(eldestKey = ShortCircuitCache.this.evictable.firstKey()), TimeUnit.NANOSECONDS)) + ShortCircuitCache.this.maxNonMmappedEvictableLifespanMs < curMs) {
                    ShortCircuitReplica replica = (ShortCircuitReplica)ShortCircuitCache.this.evictable.get(eldestKey);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("CacheCleaner: purging " + replica + ": " + StringUtils.getStackTrace(Thread.currentThread()));
                    }
                    ShortCircuitCache.this.purge(replica);
                    ++numPurged;
                }
                LOG.debug("{}: finishing cache cleaner run started at {}. Demoted {} mmapped replicas; purged {} replicas.", this, curMs, numDemoted, numPurged);
            }
            finally {
                ShortCircuitCache.this.lock.unlock();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.future != null) {
                this.future.cancel(false);
            }
        }

        public void setFuture(ScheduledFuture<?> future) {
            this.future = future;
        }

        public long getRateInMs() {
            long minLifespanMs = Math.min(ShortCircuitCache.this.maxNonMmappedEvictableLifespanMs, ShortCircuitCache.this.maxEvictableMmapedLifespanMs);
            long sampleTimeMs = minLifespanMs / 4L;
            return sampleTimeMs < 1L ? 1L : sampleTimeMs;
        }
    }
}

