/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import io.trino.hadoop.$internal.org.apache.commons.lang3.StringUtils;
import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
class ClientThrottlingAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(ClientThrottlingAnalyzer.class);
    private static final int DEFAULT_ANALYSIS_PERIOD_MS = 10000;
    private static final int MIN_ANALYSIS_PERIOD_MS = 1000;
    private static final int MAX_ANALYSIS_PERIOD_MS = 30000;
    private static final double MIN_ACCEPTABLE_ERROR_PERCENTAGE = 0.1;
    private static final double MAX_EQUILIBRIUM_ERROR_PERCENTAGE = 1.0;
    private static final double RAPID_SLEEP_DECREASE_FACTOR = 0.75;
    private static final double RAPID_SLEEP_DECREASE_TRANSITION_PERIOD_MS = 150000.0;
    private static final double SLEEP_DECREASE_FACTOR = 0.975;
    private static final double SLEEP_INCREASE_FACTOR = 1.05;
    private int analysisPeriodMs;
    private volatile int sleepDuration = 0;
    private long consecutiveNoErrorCount = 0L;
    private String name = null;
    private Timer timer = null;
    private AtomicReference<BlobOperationMetrics> blobMetrics = null;

    private ClientThrottlingAnalyzer() {
    }

    ClientThrottlingAnalyzer(String name) throws IllegalArgumentException {
        this(name, 10000);
    }

    ClientThrottlingAnalyzer(String name, int period) throws IllegalArgumentException {
        Preconditions.checkArgument(StringUtils.isNotEmpty(name), "The argument 'name' cannot be null or empty.");
        Preconditions.checkArgument(period >= 1000 && period <= 30000, "The argument 'period' must be between 1000 and 30000.");
        this.name = name;
        this.analysisPeriodMs = period;
        this.blobMetrics = new AtomicReference<BlobOperationMetrics>(new BlobOperationMetrics(System.currentTimeMillis()));
        this.timer = new Timer(String.format("wasb-timer-client-throttling-analyzer-%s", name), true);
        this.timer.schedule((TimerTask)new TimerTaskImpl(), this.analysisPeriodMs, (long)this.analysisPeriodMs);
    }

    public void addBytesTransferred(long count, boolean isFailedOperation) {
        BlobOperationMetrics metrics = this.blobMetrics.get();
        if (isFailedOperation) {
            metrics.bytesFailed.addAndGet(count);
            metrics.operationsFailed.incrementAndGet();
        } else {
            metrics.bytesSuccessful.addAndGet(count);
            metrics.operationsSuccessful.incrementAndGet();
        }
    }

    public void suspendIfNecessary() {
        int duration = this.sleepDuration;
        if (duration > 0) {
            try {
                Thread.sleep(duration);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @VisibleForTesting
    int getSleepDuration() {
        return this.sleepDuration;
    }

    private int analyzeMetricsAndUpdateSleepDuration(BlobOperationMetrics metrics, int sleepDuration) {
        double newSleepDuration;
        double percentageConversionFactor = 100.0;
        double bytesFailed = metrics.bytesFailed.get();
        double bytesSuccessful = metrics.bytesSuccessful.get();
        double operationsFailed = metrics.operationsFailed.get();
        double operationsSuccessful = metrics.operationsSuccessful.get();
        double errorPercentage = bytesFailed <= 0.0 ? 0.0 : 100.0 * bytesFailed / (bytesFailed + bytesSuccessful);
        long periodMs = metrics.endTime - metrics.startTime;
        if (errorPercentage < 0.1) {
            ++this.consecutiveNoErrorCount;
            double reductionFactor = (double)(this.consecutiveNoErrorCount * (long)this.analysisPeriodMs) >= 150000.0 ? 0.75 : 0.975;
            newSleepDuration = (double)sleepDuration * reductionFactor;
        } else if (errorPercentage < 1.0) {
            newSleepDuration = sleepDuration;
        } else {
            this.consecutiveNoErrorCount = 0L;
            double additionalDelayNeeded = 5 * this.analysisPeriodMs;
            if (bytesSuccessful > 0.0) {
                additionalDelayNeeded = (bytesSuccessful + bytesFailed) * (double)periodMs / bytesSuccessful - (double)periodMs;
            }
            newSleepDuration = additionalDelayNeeded / (operationsFailed + operationsSuccessful);
            double maxSleepDuration = this.analysisPeriodMs;
            double minSleepDuration = (double)sleepDuration * 1.05;
            newSleepDuration = Math.max(newSleepDuration, minSleepDuration) + 1.0;
            newSleepDuration = Math.min(newSleepDuration, maxSleepDuration);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("%5.5s, %10d, %10d, %10d, %10d, %6.2f, %5d, %5d, %5d", this.name, (int)bytesFailed, (int)bytesSuccessful, (int)operationsFailed, (int)operationsSuccessful, errorPercentage, periodMs, sleepDuration, (int)newSleepDuration));
        }
        return (int)newSleepDuration;
    }

    static class BlobOperationMetrics {
        private AtomicLong bytesFailed;
        private AtomicLong bytesSuccessful;
        private AtomicLong operationsFailed;
        private AtomicLong operationsSuccessful;
        private long endTime;
        private long startTime;

        BlobOperationMetrics(long startTime) {
            this.startTime = startTime;
            this.bytesFailed = new AtomicLong();
            this.bytesSuccessful = new AtomicLong();
            this.operationsFailed = new AtomicLong();
            this.operationsSuccessful = new AtomicLong();
        }
    }

    class TimerTaskImpl
    extends TimerTask {
        private AtomicInteger doingWork = new AtomicInteger(0);

        TimerTaskImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean doWork = false;
            try {
                doWork = this.doingWork.compareAndSet(0, 1);
                if (!doWork) {
                    return;
                }
                long now = System.currentTimeMillis();
                if (now - ((BlobOperationMetrics)ClientThrottlingAnalyzer.this.blobMetrics.get()).startTime >= (long)ClientThrottlingAnalyzer.this.analysisPeriodMs) {
                    BlobOperationMetrics oldMetrics = ClientThrottlingAnalyzer.this.blobMetrics.getAndSet(new BlobOperationMetrics(now));
                    oldMetrics.endTime = now;
                    ClientThrottlingAnalyzer.this.sleepDuration = ClientThrottlingAnalyzer.this.analyzeMetricsAndUpdateSleepDuration(oldMetrics, ClientThrottlingAnalyzer.this.sleepDuration);
                }
            }
            finally {
                if (doWork) {
                    this.doingWork.set(0);
                }
            }
        }
    }
}

