/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.org.apache.kerby.kerberos.provider.token;

import com.nimbusds.jose.PlainHeader;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.AuthToken;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.provider.token.JwtUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class JwtAuthToken
implements AuthToken {
    private JWTClaimsSet jwtClaims;
    private Boolean isIdToken = true;
    private Boolean isAcToken = false;

    public JwtAuthToken() {
        this(new JWTClaimsSet());
    }

    public JwtAuthToken(JWTClaimsSet jwtClaims) {
        this.jwtClaims = jwtClaims;
    }

    public JwtAuthToken(ReadOnlyJWTClaimsSet jwtClaims) {
        this.jwtClaims = JwtUtil.from(jwtClaims);
    }

    protected JWT getJwt() {
        String jti = this.jwtClaims.getJWTID();
        if (jti == null || jti.isEmpty()) {
            jti = UUID.randomUUID().toString();
            this.jwtClaims.setJWTID(jti);
        }
        PlainHeader header = new PlainHeader();
        PlainJWT jwt = new PlainJWT(header, (ReadOnlyJWTClaimsSet)this.jwtClaims);
        return jwt;
    }

    @Override
    public String getSubject() {
        return this.jwtClaims.getSubject();
    }

    @Override
    public void setSubject(String sub) {
        this.jwtClaims.setSubject(sub);
    }

    @Override
    public String getIssuer() {
        return this.jwtClaims.getIssuer();
    }

    @Override
    public void setIssuer(String issuer) {
        this.jwtClaims.setIssuer(issuer);
    }

    @Override
    public List<String> getAudiences() {
        return this.jwtClaims.getAudience();
    }

    @Override
    public void setAudiences(List<String> audiences) {
        this.jwtClaims.setAudience(audiences);
    }

    @Override
    public boolean isIdToken() {
        return this.isIdToken;
    }

    @Override
    public void isIdToken(boolean isIdToken) {
        this.isIdToken = isIdToken;
    }

    @Override
    public boolean isAcToken() {
        return this.isAcToken;
    }

    @Override
    public void isAcToken(boolean isAcToken) {
        this.isAcToken = isAcToken;
    }

    @Override
    public boolean isBearerToken() {
        return true;
    }

    @Override
    public boolean isHolderOfKeyToken() {
        return false;
    }

    @Override
    public Date getExpiredTime() {
        return this.jwtClaims.getExpirationTime();
    }

    @Override
    public void setExpirationTime(Date exp) {
        this.jwtClaims.setExpirationTime(exp);
    }

    @Override
    public Date getNotBeforeTime() {
        return this.jwtClaims.getNotBeforeTime();
    }

    @Override
    public void setNotBeforeTime(Date nbt) {
        this.jwtClaims.setNotBeforeTime(nbt);
    }

    @Override
    public Date getIssueTime() {
        return this.jwtClaims.getIssueTime();
    }

    @Override
    public void setIssueTime(Date iat) {
        this.jwtClaims.setIssueTime(iat);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.jwtClaims.getAllClaims();
    }

    @Override
    public void addAttribute(String name, Object value) {
        this.jwtClaims.setCustomClaim(name, value);
    }
}

