/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.preauth;

import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbException;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.KdcContext;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.preauth.AbstractPreauthPlugin;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.preauth.KdcPreauth;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.preauth.PreauthContext;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.preauth.PreauthHandle;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.preauth.builtin.EncTsPreauth;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.preauth.builtin.TgtPreauth;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.preauth.pkinit.PkinitPreauth;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.preauth.token.TokenPreauth;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.request.KdcRequest;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.pa.PaData;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.pa.PaDataEntry;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.pa.PaDataType;
import java.util.ArrayList;
import java.util.List;

public class PreauthHandler {
    private List<KdcPreauth> preauths;

    public void init() {
        this.loadPreauthPlugins();
    }

    private void loadPreauthPlugins() {
        this.preauths = new ArrayList<KdcPreauth>();
        AbstractPreauthPlugin preauth = new EncTsPreauth();
        this.preauths.add(preauth);
        preauth = new TgtPreauth();
        this.preauths.add(preauth);
        preauth = new TokenPreauth();
        this.preauths.add(preauth);
        preauth = new PkinitPreauth();
        this.preauths.add(preauth);
    }

    public void initWith(KdcContext context) {
        for (KdcPreauth preauth : this.preauths) {
            preauth.initWith(context);
        }
    }

    public PreauthContext preparePreauthContext(KdcRequest kdcRequest) {
        PreauthContext preauthContext = new PreauthContext();
        KdcContext kdcContext = kdcRequest.getKdcContext();
        this.initWith(kdcContext);
        preauthContext.setPreauthRequired(kdcContext.getConfig().isPreauthRequired());
        for (KdcPreauth preauth : this.preauths) {
            PreauthHandle handle = new PreauthHandle(preauth);
            handle.initRequestContext(kdcRequest);
            preauthContext.getHandles().add(handle);
        }
        return preauthContext;
    }

    public void provideEdata(KdcRequest kdcRequest, PaData outPaData) throws KrbException {
        PreauthContext preauthContext = kdcRequest.getPreauthContext();
        for (PreauthHandle handle : preauthContext.getHandles()) {
            handle.provideEdata(kdcRequest, outPaData);
        }
    }

    public void verify(KdcRequest kdcRequest, PaData paData) throws KrbException {
        for (PaDataEntry paEntry : paData.getElements()) {
            PreauthHandle handle = this.findHandle(kdcRequest, paEntry.getPaDataType());
            if (handle == null) continue;
            handle.verify(kdcRequest, paEntry);
        }
    }

    public void providePaData(KdcRequest kdcRequest, PaData paData) {
        PreauthContext preauthContext = kdcRequest.getPreauthContext();
        for (PreauthHandle handle : preauthContext.getHandles()) {
            handle.providePaData(kdcRequest, paData);
        }
    }

    private PreauthHandle findHandle(KdcRequest kdcRequest, PaDataType paType) {
        PreauthContext preauthContext = kdcRequest.getPreauthContext();
        for (PreauthHandle handle : preauthContext.getHandles()) {
            for (PaDataType pt : handle.preauth.getPaTypes()) {
                if (pt != paType) continue;
                return handle;
            }
        }
        return null;
    }

    public void destroy() {
        for (KdcPreauth preauth : this.preauths) {
            preauth.destroy();
        }
    }

    public static boolean isToken(PaData paData) {
        if (paData != null) {
            for (PaDataEntry paEntry : paData.getElements()) {
                if (paEntry.getPaDataType() != PaDataType.TOKEN_REQUEST) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPkinit(PaData paData) {
        if (paData != null) {
            for (PaDataEntry paEntry : paData.getElements()) {
                if (paEntry.getPaDataType() != PaDataType.PK_AS_REQ) continue;
                return true;
            }
        }
        return false;
    }
}

